/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class ShapeMorph
extends Bouncelet {
    public InFrequencies inFreqs1 = new InFrequencies("in1", "Source shape");
    public InFrequencies inFreqs2 = new InFrequencies("in2", "Target shape");
    public InDouble inThreshold = new InDouble("threshold", "Maximum correction [dB]", 40.0, 0.0, 96.0);
    public OutFrequencies outFreqs = new OutFrequencies("out", "Morphing shape");
    private float minRatio;
    private float maxRatio;

    public ShapeMorph() {
        super("audio.effect.spectrum.shape.shape-morph", "Create a morphing shape (shape2 / shape1)");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inThreshold.isModified()) {
            double threshold = (Double)this.inThreshold.read();
            this.maxRatio = (float)AudioMath.dbToLevel(threshold);
            this.minRatio = 1.0f / this.maxRatio;
        }
        FrequenciesData dstFreqs = (FrequenciesData)this.inFreqs2.peek();
        this.outFreqs.prepare(dstFreqs.nbChannels, dstFreqs.nbBins);
    }

    private void process() {
        FrequenciesData srcFreqs = (FrequenciesData)this.inFreqs1.read();
        FrequenciesData dstFreqs = (FrequenciesData)this.inFreqs2.read();
        FrequenciesData resFreqs = (FrequenciesData)this.outFreqs.get();
        int chan = 0;
        while (chan < dstFreqs.nbChannels) {
            float[] srcInput = srcFreqs.data[chan % srcFreqs.nbChannels];
            float[] dstInput = dstFreqs.data[chan];
            float[] output = resFreqs.data[chan];
            this.process(srcInput, dstInput, output);
            ++chan;
        }
    }

    private void process(float[] src, float[] dst, float[] output) {
        float srcPEnergy = 0.0f;
        float outPEnergy = 0.0f;
        int i = 0;
        while (i < output.length) {
            float value;
            float srcVal = src[i];
            srcPEnergy += srcVal * srcVal;
            float f = value = srcVal == 0.0f ? 0.0f : dst[i] / srcVal;
            if (value < this.minRatio) {
                value = this.minRatio;
            } else if (value > this.maxRatio) {
                value = this.maxRatio;
            }
            output[i] = value;
            outPEnergy += value * value;
            ++i;
        }
        float correction = (float)Math.sqrt(srcPEnergy / outPEnergy);
        if (correction > this.maxRatio) {
            correction = this.maxRatio;
        }
        int i2 = 0;
        while (i2 < output.length) {
            int n = i2++;
            output[n] = output[n] * correction;
        }
    }
}

