/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.BeatExtractEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.utils.Log;

public class BeatBox
extends AudioStateSpectrumBouncelet<BeatExtractEngine> {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InSpectrumPreset<BeatBox, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.BeatExtract);
    public InDouble inThreshold = new InDouble("threshold", "Duration threshold [s]", 0.1, 0.001, 10.0);
    public InDouble inSmoothing = new InDouble("smoothing", "Smoothing duration [s]", 0.03, 1.0E-4, 0.1);
    public InInt inAvgSpan = new InInt("avgspan", "Averaging [bins]", 20, 0, 50);
    public InDouble inCoverage = new InDouble("coverage", "Coverage [dB]", 30.0, 1.0, 100.0);
    public InDouble inGate = new InDouble("gate", "Cut gate level [dB]", 5.0, 0.0, 10.0);
    public InDouble inAmplitude = new InDouble("amplitude", "Max amplitude", 12.0, -24.0, 24.0);
    public InBoolean inQuadratic = new InBoolean("quadratic", "Square amplitudes", false);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private float[] mountains;
    private float[] shadow;
    private int nbBins;

    public BeatBox() {
        super("audio.effect.spectrum.time.beat-box", "Enhance rough sounds (rhythmics)", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inPreset.setSkillType(SkillType.SIMPLIFIED);
        this.inThreshold.setScaleType(ScaleType.LOG2);
        this.inSmoothing.setScaleType(ScaleType.LOG2);
        this.inAvgSpan.setScaleType(ScaleType.CUBE);
        this.inAvgSpan.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setSkillType(SkillType.ADVANCED);
        this.inSmoothing.setSkillType(SkillType.ADVANCED);
        this.inCoverage.setSkillType(SkillType.ADVANCED);
        this.inGate.setSkillType(SkillType.ADVANCED);
        this.inAmplitude.setSkillType(SkillType.ADVANCED);
        this.inQuadratic.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public boolean checkForChanges() {
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        if (audio.nbBins != this.nbBins) {
            return true;
        }
        return this.inThreshold.isModified() || this.inSmoothing.isModified();
    }

    protected BeatExtractEngine[] createStates(int nbChans) {
        int avgLength;
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        this.nbBins = audio.nbBins;
        int length = (int)((Double)this.inThreshold.read() / audio.getRealDuration() + 0.5);
        if (length < 1) {
            length = 1;
        }
        if ((avgLength = (int)((Double)this.inSmoothing.read() / audio.getRealDuration() + 0.5)) < 1) {
            avgLength = 1;
        }
        Log.debug("Length={0}; Avg Length={1}", length, avgLength);
        BeatExtractEngine[] result = new BeatExtractEngine[nbChans];
        int i = 0;
        while (i < nbChans) {
            result[i] = new BeatExtractEngine(audio.nbBins, length, avgLength);
            ++i;
        }
        this.mountains = new float[audio.nbBins];
        this.shadow = new float[audio.nbBins];
        return result;
    }

    @Override
    public void process(BeatExtractEngine engine, int chan, Cmplx[] input, Cmplx[] output) {
        float amplitude;
        float gate;
        float coverage;
        float gatedCoverage;
        engine.push(input);
        int i = 0;
        while (i < input.length) {
            float roughnessNext;
            float roughnessPrev;
            float level = input[i].magApprox();
            float roughness = this.getRoughness(engine, level, i);
            if (i > 0 && (roughnessPrev = this.getRoughness(engine, level, i - 1)) < roughness) {
                roughness = roughnessPrev;
            }
            if (i < input.length - 1 && (roughnessNext = this.getRoughness(engine, level, i + 1)) < roughness) {
                roughness = roughnessNext;
            }
            this.mountains[i] = (float)AudioMath.levelToDb0(roughness);
            ++i;
        }
        int avgSpan = (Integer)this.inAvgSpan.read();
        float sum = 0.0f;
        int i2 = -avgSpan;
        while (i2 < avgSpan) {
            sum += this.pick(i2);
            ++i2;
        }
        float correction = 1.0f / (float)(avgSpan * 2 + 1);
        int i3 = 0;
        while (i3 < input.length) {
            this.shadow[i3] = (sum += this.pick(i3 + avgSpan)) * correction;
            sum -= this.pick(i3 - avgSpan);
            ++i3;
        }
        if (input != output) {
            i3 = 0;
            while (i3 < input.length) {
                output[i3].set(input[i3]);
                ++i3;
            }
        }
        if ((gatedCoverage = (coverage = (float)((Double)this.inCoverage.read()).doubleValue()) - (gate = (float)((Double)this.inGate.read()).doubleValue())) <= 1.0f) {
            gatedCoverage = 1.0f;
        }
        boolean reverse = (double)(amplitude = (float)((Double)this.inAmplitude.read()).doubleValue()) < 0.0;
        amplitude = (float)AudioMath.dbToLevel(Math.abs(amplitude));
        boolean squared = (Boolean)this.inQuadratic.read();
        int i4 = 0;
        while (i4 < input.length) {
            float level = this.shadow[i4];
            if (level > coverage) {
                level = coverage;
            }
            if (reverse) {
                level = coverage - level;
            }
            if ((level -= gate) < 0.0f) {
                level = 0.0f;
            }
            if ((level = squared ? level / gatedCoverage * (level / gatedCoverage) * amplitude : level * amplitude / gatedCoverage) > 1.0f) {
                level = 1.0f;
            }
            output[i4].mul(level);
            ++i4;
        }
    }

    private float getRoughness(BeatExtractEngine engine, float level, int binNum) {
        float minAvg = engine.getMinAvgLevel(binNum);
        if (level > minAvg && minAvg != 0.0f) {
            return level / minAvg;
        }
        return 1.0f;
    }

    private float pick(int index) {
        if (index < 0) {
            return this.mountains[-index];
        }
        if (index >= this.nbBins) {
            return this.mountains[this.nbBins * 2 - index - 1];
        }
        return this.mountains[index];
    }

    public static enum Preset implements Presetter<BeatBox>
    {
        BeatExtract{

            @Override
            public void apply(BeatBox bouncelet, PortValueSetter setter) {
                Preset.reset(bouncelet, setter);
                setter.setPortValue(bouncelet.inAvgSpan, 20);
                setter.setPortValue(bouncelet.inCoverage, 30.0);
                setter.setPortValue(bouncelet.inGate, 5.0);
                setter.setPortValue(bouncelet.inAmplitude, 12.0);
                setter.setPortValue(bouncelet.inQuadratic, false);
            }
        }
        ,
        BeatSoftEnhance{

            @Override
            public void apply(BeatBox bouncelet, PortValueSetter setter) {
                Preset.reset(bouncelet, setter);
                setter.setPortValue(bouncelet.inAvgSpan, 20);
                setter.setPortValue(bouncelet.inCoverage, 30.0);
                setter.setPortValue(bouncelet.inGate, 0.0);
                setter.setPortValue(bouncelet.inAmplitude, 12.0);
                setter.setPortValue(bouncelet.inQuadratic, false);
            }
        }
        ,
        BeatHardEnhance{

            @Override
            public void apply(BeatBox bouncelet, PortValueSetter setter) {
                Preset.reset(bouncelet, setter);
                setter.setPortValue(bouncelet.inAvgSpan, 20);
                setter.setPortValue(bouncelet.inCoverage, 30.0);
                setter.setPortValue(bouncelet.inGate, 0.0);
                setter.setPortValue(bouncelet.inAmplitude, 12.0);
                setter.setPortValue(bouncelet.inQuadratic, true);
            }
        }
        ,
        BeatFilter{

            @Override
            public void apply(BeatBox bouncelet, PortValueSetter setter) {
                Preset.reset(bouncelet, setter);
                setter.setPortValue(bouncelet.inAvgSpan, 5);
                setter.setPortValue(bouncelet.inCoverage, 20.0);
                setter.setPortValue(bouncelet.inGate, 0.0);
                setter.setPortValue(bouncelet.inAmplitude, -1.0);
                setter.setPortValue(bouncelet.inQuadratic, true);
            }
        }
        ,
        P3{

            @Override
            public void apply(BeatBox bouncelet, PortValueSetter setter) {
                Preset.reset(bouncelet, setter);
                setter.setPortValue(bouncelet.inAvgSpan, 5);
                setter.setPortValue(bouncelet.inCoverage, 30.0);
                setter.setPortValue(bouncelet.inGate, 0.0);
                setter.setPortValue(bouncelet.inAmplitude, 12.0);
                setter.setPortValue(bouncelet.inQuadratic, false);
            }
        };


        private static void reset(BeatBox bouncelet, PortValueSetter setter) {
            setter.setBlockSize(PowerOf2.p2048);
            setter.setOverlap(PowerOf2.p4);
            bouncelet.inThreshold.write(0.1);
            bouncelet.inSmoothing.write(0.03);
        }
    }
}

