/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.BeatExtractEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.utils.Log;

public class BeatExtract
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InSpectrumPreset<BeatExtract, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.ShortExtract);
    public InDouble inThreshold = new InDouble("threshold", "Duration threshold (and minimizer) [s]", 0.1, 0.001, 10.0);
    public InDouble inSensivity = new InDouble("sensivity", "Sensivity [dB]", 20.0, 0.0, 100.0);
    public InputPort<StereoMode> inStereoMode = new InputPort<StereoMode>(StereoMode.class, "Stereo Mode", "Stereo handling scheme", StereoMode.Independent);
    public InDouble inSmoothing = new InDouble("smoothing", "Smoothing (averaging) duration [s]", 0.03, 1.0E-4, 0.1);
    public InBoolean inDecayEnabled = new InBoolean("decay.enabled", "Enable short sounds decay", true);
    public InDouble inDecaySpeed = new InDouble("decay.speed", "Short sounds decay speed [log2(dB/s)]", 4.0, 1.0, 10.0);
    public InBoolean inFreqTrack = new InBoolean("freq.track", "Track varying frequencies", false);
    public InInt inSpread = new InInt("spreading", "Spreading of short sounds in frequencies [bins]", 0, 0, 10);
    public InInt inMinSpan = new InInt("minspan", "Minimum short sound span [bins]", 1, 1, 30);
    public InDouble inFloor = new InDouble("floor", "Floor threshold level [dB]", -80.0, -100.0, 0.0);
    public OutSpectrum outShort = new OutSpectrum("out.short", "Short sounds");
    public OutSpectrum outLong = new OutSpectrum("out.long", "Long sounds");
    private StereoMode stereoMode;
    private BeatExtractEngine[] engines;
    private BitSet[] beatSet;
    private Cmplx[] source;
    private int[][] ages;
    private float[][] decayLevels;
    private int nbBins;
    private int nbChannels;
    private double decayFactor;
    private float floor;

    public BeatExtract() {
        super("audio.effect.spectrum.time.beat-x", "Split short and long sounds");
        super.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setScaleType(ScaleType.LOG2);
        this.inSmoothing.setScaleType(ScaleType.LOG2);
        this.inDecaySpeed.setScaleType(ScaleType.LOG2);
        this.inPreset.setSkillType(SkillType.SIMPLIFIED);
        this.inThreshold.setSkillType(SkillType.NORMAL);
        this.inSensivity.setSkillType(SkillType.NORMAL);
        this.inStereoMode.setSkillType(SkillType.NORMAL);
        this.inSmoothing.setSkillType(SkillType.ADVANCED);
        this.inDecayEnabled.setSkillType(SkillType.ADVANCED);
        this.inDecaySpeed.setSkillType(SkillType.ADVANCED);
        this.inSpread.setSkillType(SkillType.ADVANCED);
        this.inMinSpan.setSkillType(SkillType.ADVANCED);
        this.inFloor.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outShort;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outLong;
    }

    @Override
    public void setup() {
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        if (this.engines == null || this.nbChannels != audio.nbChannels || this.nbBins != audio.nbBins || this.inThreshold.isModified() || this.inStereoMode.isModified() || this.inSmoothing.isModified()) {
            int avgLength;
            double threshold = (Double)this.inThreshold.read();
            int length = (int)(threshold / audio.getRealDuration() + 0.5);
            if (length < 1) {
                length = 1;
            }
            if ((avgLength = (int)((Double)this.inSmoothing.read() / audio.getRealDuration() + 0.5)) < 1) {
                avgLength = 1;
            }
            Log.debug("Buffer length: {0}, Smoothing length: {1}", length, avgLength);
            this.nbBins = audio.nbBins;
            this.nbChannels = audio.nbChannels;
            this.stereoMode = this.inStereoMode.read();
            if (this.stereoMode == StereoMode.Independent) {
                this.engines = new BeatExtractEngine[audio.nbChannels];
                int i = 0;
                while (i < this.engines.length) {
                    this.engines[i] = new BeatExtractEngine(this.nbBins, length, avgLength);
                    ++i;
                }
                this.beatSet = new BitSet[audio.nbChannels];
                i = 0;
                while (i < this.beatSet.length) {
                    this.beatSet[i] = new BitSet(this.nbBins);
                    ++i;
                }
                this.ages = new int[audio.nbChannels][this.nbBins];
                this.decayLevels = new float[audio.nbChannels][this.nbBins];
                this.source = null;
            } else {
                this.engines = new BeatExtractEngine[1];
                this.engines[0] = new BeatExtractEngine(this.nbBins, length, avgLength);
                this.beatSet = new BitSet[1];
                this.beatSet[0] = new BitSet(this.nbBins);
                this.ages = new int[1][this.nbBins];
                this.decayLevels = new float[1][this.nbBins];
                this.source = Cmplx.newArray(this.nbBins);
            }
        }
        if (this.inDecaySpeed.isModified()) {
            this.decayFactor = Math.pow(2.0, (Double)this.inDecaySpeed.read());
            this.decayFactor *= audio.getRealDuration();
            this.decayFactor = AudioMath.dbToLevel(-this.decayFactor);
        }
        if (this.inFloor.isModified()) {
            this.floor = (float)((Double)this.inFloor.read()).doubleValue();
        }
    }

    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] shortx, Cmplx[] longx) {
        double factor = AudioMath.dbToLevel((Double)this.inSensivity.read());
        boolean isDecayEnabled = (Boolean)this.inDecayEnabled.read();
        boolean isTracking = (Boolean)this.inFreqTrack.read();
        if (this.stereoMode == StereoMode.Independent) {
            BeatExtractEngine engine = this.engines[chan];
            BitSet beats = this.beatSet[chan];
            engine.push(input);
            int maxAge = engine.getLength();
            this.applyThresholds(input, beats, factor, isDecayEnabled, isTracking, engine, chan, maxAge);
            this.applyMinSpan(beats);
            this.applySpreading(beats);
            this.extract(input, shortx, longx, beats);
        } else {
            if (chan == 0) {
                SpectrumData audio = (SpectrumData)this.inAudio.peek();
                audio.fillSum(this.source);
                BeatExtractEngine engine = this.engines[0];
                BitSet beats = this.beatSet[0];
                engine.push(this.source);
                int maxAge = engine.getLength();
                this.applyThresholds(this.source, beats, factor, isDecayEnabled, isTracking, engine, chan, maxAge);
                this.applyMinSpan(beats);
                this.applySpreading(beats);
            }
            this.extract(input, shortx, longx, this.beatSet[0]);
        }
    }

    private void applyThresholds(Cmplx[] input, BitSet beats, double factor, boolean isDecayEnabled, boolean isTracking, BeatExtractEngine engine, int chan, int maxAge) {
        int i = 0;
        while (i < input.length) {
            float threshold;
            float level = input[i].magApprox();
            if (isDecayEnabled) {
                level = this.decayLevel(chan, i, level, (float)this.decayFactor);
            }
            if ((threshold = engine.getMinAvgLevel(i)) < this.floor) {
                threshold = this.floor;
            }
            threshold *= (float)factor;
            if (isTracking) {
                float thresholdNext;
                float thresholdPrev;
                if (i > 0 && (thresholdPrev = engine.getMinAvgLevel(i - 1) * (float)factor) > threshold) {
                    threshold = thresholdPrev;
                }
                if (i < input.length - 1 && (thresholdNext = engine.getMinAvgLevel(i + 1) * (float)factor) > threshold) {
                    threshold = thresholdNext;
                }
            }
            if (level < threshold) {
                this.incAge(chan, i);
            } else {
                this.resetAge(chan, i);
            }
            int age = this.getAge(chan, i);
            if (age > maxAge) {
                beats.clear(i);
            } else {
                beats.set(i);
            }
            ++i;
        }
    }

    private void applyMinSpan(BitSet beats) {
        int minSpan = (Integer)this.inMinSpan.read();
        if (minSpan > 1) {
            int start = -1;
            int i = 0;
            while (i <= this.nbBins) {
                boolean isShort;
                boolean bl = isShort = i < this.nbBins && beats.get(i);
                if (isShort) {
                    if (start < 0) {
                        start = i;
                    }
                } else if (start >= 0) {
                    int span = i - start;
                    if (span < minSpan) {
                        int j = start;
                        while (j < i) {
                            beats.clear(j);
                            ++j;
                        }
                    }
                    start = -1;
                }
                ++i;
            }
        }
    }

    private void applySpreading(BitSet beats) {
        int spread = (Integer)this.inSpread.read();
        if (spread > 0) {
            int count = 0;
            int i = 0;
            while (i < this.nbBins) {
                count = this.spread(beats, i, spread, count);
                ++i;
            }
            i = this.nbBins - 1;
            while (i >= 0) {
                count = this.spread(beats, i, spread, count);
                --i;
            }
        }
    }

    private int spread(BitSet beats, int i, int spread, int count) {
        if (!beats.get(i)) {
            if (count > 0) {
                beats.set(i);
                --count;
            }
        } else {
            count = spread;
        }
        return count;
    }

    private void extract(Cmplx[] input, Cmplx[] shortx, Cmplx[] longx, BitSet beats) {
        assert (input.length == this.nbBins && shortx.length == this.nbBins && longx.length == this.nbBins);
        int i = 0;
        while (i < this.nbBins) {
            if (beats.get(i)) {
                shortx[i].set(input[i]);
                longx[i].clear();
            } else {
                longx[i].set(input[i]);
                shortx[i].clear();
            }
            ++i;
        }
    }

    private int getAge(int chan, int binNum) {
        return this.ages[chan][binNum];
    }

    private int incAge(int chan, int binNum) {
        int[] nArray = this.ages[chan];
        int n = binNum;
        int n2 = nArray[n];
        nArray[n] = n2 + 1;
        return n2;
    }

    private void resetAge(int chan, int binNum) {
        this.ages[chan][binNum] = 0;
    }

    private float decayLevel(int chan, int binNum, float level, float decaySpeed) {
        float[] fArray = this.decayLevels[chan];
        int n = binNum;
        fArray[n] = fArray[n] * decaySpeed;
        if (level > this.decayLevels[chan][binNum]) {
            this.decayLevels[chan][binNum] = level;
        }
        return this.decayLevels[chan][binNum];
    }

    public static enum Preset implements Presetter<BeatExtract>
    {
        ShortExtract{

            @Override
            public void apply(BeatExtract b, PortValueSetter setter) {
                setter.setPortValue(b.inThreshold, 0.1);
                setter.setPortValue(b.inSensivity, 20.0);
                setter.setPortValue(b.inSmoothing, 0.03);
                setter.setPortValue(b.inDecayEnabled, true);
                setter.setPortValue(b.inDecaySpeed, 4.0);
                setter.setPortValue(b.inFreqTrack, false);
                setter.setPortValue(b.inSpread, 0);
                setter.setPortValue(b.inMinSpan, 1);
                setter.setOverlap(PowerOf2.p4);
                setter.setBlockSize(PowerOf2.p512);
            }
        }
        ,
        RythmExtract{

            @Override
            public void apply(BeatExtract b, PortValueSetter setter) {
                setter.setPortValue(b.inThreshold, 0.016);
                setter.setPortValue(b.inSensivity, 15.0);
                setter.setPortValue(b.inSmoothing, 0.015);
                setter.setPortValue(b.inDecayEnabled, false);
                setter.setPortValue(b.inFreqTrack, true);
                setter.setPortValue(b.inSpread, 3);
                setter.setPortValue(b.inMinSpan, 1);
                setter.setOverlap(PowerOf2.p4);
                setter.setBlockSize(PowerOf2.p128);
            }
        }
        ,
        TransientsExtract{

            @Override
            public void apply(BeatExtract b, PortValueSetter setter) {
                setter.setPortValue(b.inThreshold, 0.016);
                setter.setPortValue(b.inSensivity, 10.0);
                setter.setPortValue(b.inSmoothing, 0.015);
                setter.setPortValue(b.inDecayEnabled, false);
                setter.setPortValue(b.inFreqTrack, true);
                setter.setPortValue(b.inSpread, 0);
                setter.setPortValue(b.inMinSpan, 10);
                setter.setOverlap(PowerOf2.p4);
                setter.setBlockSize(PowerOf2.p128);
            }
        };

    }

    public static enum StereoMode {
        Independent("Independent"),
        MixedLock("Mixed Lock");

        private String name;

        private StereoMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

