/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import java.util.Arrays;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.charmed.FourierEngine;

public class CurvedDelayEngine
extends FourierEngine {
    private final int nbBands;
    private final float[][] mergeBuffer;
    private final int[] mergeIndex;
    private final float[] buffer;
    private final Cmplx[] filtered;
    private final Buffer[] delayLines;

    public CurvedDelayEngine(PowerOf2 windowSize, int nbBands) {
        super(windowSize.intValue(), windowSize.intValue() / 2, false, false);
        this.nbBands = nbBands;
        this.mergeBuffer = new float[nbBands][windowSize.intValue()];
        this.mergeIndex = new int[nbBands];
        this.buffer = new float[windowSize.intValue() / 2];
        this.filtered = Cmplx.newArray(windowSize.intValue() / 2 + 1);
        this.delayLines = new Buffer[nbBands];
    }

    public void setDelay(double delay) {
        int i = 0;
        while (i < this.nbBands) {
            double duration = delay < 0.0 ? -delay * (double)(this.nbBands - i) / (double)this.nbBands : delay * (double)i / (double)this.nbBands;
            int length = (int)(duration * (double)AudioConfig.getSampleRate() + 0.5);
            if (this.delayLines[i] == null) {
                this.delayLines[i] = new Buffer(length);
            } else {
                this.delayLines[i].setSize(length);
            }
            ++i;
        }
    }

    protected void process(Cmplx[] spectrum) {
    }

    public void process(float[] input, float[] output) {
        Arrays.fill(output, 0.0f);
        this.wave2spectrum(input, 0, input.length);
        int stopBin = 0;
        int b = 0;
        while (b < this.nbBands) {
            double stop = Math.exp(Math.log(b + 1) * Math.log(this.spectrum.length) / Math.log(this.nbBands));
            int startBin = stopBin;
            stopBin = (int)stop;
            int i = 0;
            while (i < this.spectrum.length) {
                if (i >= startBin && i < stopBin) {
                    this.filtered[i].set(this.spectrum[i]);
                } else {
                    this.filtered[i].set(0.0f, 0.0f);
                }
                ++i;
            }
            this.mergeIndex[b] = this.spectrum2wave(this.filtered, this.mergeBuffer[b], this.mergeIndex[b], this.buffer, 0, this.buffer.length);
            if (this.delayLines[b].getSize() > 0) {
                this.delayLines[b].pushArray(this.buffer, this.buffer);
            }
            i = 0;
            while (i < this.buffer.length) {
                int n = i;
                output[n] = output[n] + this.buffer[i];
                ++i;
            }
            ++b;
        }
    }
}

