/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.EdgeExtractor;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;

public class EdgeExtract
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InSpectrumPreset<EdgeExtract, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.Short);
    public InputPort<StereoMode> inStereoMode = new InputPort<StereoMode>(StereoMode.class, "Stereo Mode", "Stereo handling scheme", StereoMode.SplitLock);
    public InDouble inThreshold = new InDouble("threshold", "Duration threshold (minimizer) [s]", 0.017, 0.001, 10.0);
    public InDouble inSmoothing = new InDouble("smoothing", "Smoothing duration (averager) [s]", 0.014, 1.0E-4, 1.0);
    public InDouble inSensivity = new InDouble("sensivity", "Sensivity [dB]", 5.0, 0.0, 100.0);
    public InDouble inAttackDelay = new InDouble("attack.delay", "Attack delay [s]", 0.0, 0.0, 1.0);
    public InDouble inAttackSpeed = new InDouble("attack.speed", "Attack speed [dB]", 1.0, 0.0, 100.0);
    public InInt inMinSpan = new InInt("minSpan", "Minimal spectral spanning", 10, 1, 100);
    public InInt inSpread = new InInt("spread", "Spreading [bin]", 3, 0, 20);
    public InBoolean inHard = new InBoolean("hard", "Propagate start levels", false);
    public InDouble inMaxJump = new InDouble("maxJump", "Maximum attack jump", 40.0, 0.0, 120.0);
    public OutSpectrum outShort = new OutSpectrum("out.short", "Short sounds");
    public OutSpectrum outLong = new OutSpectrum("out.long", "Long sounds");
    private EdgeExtractor extractor;
    private EdgeExtractor[] extractors;
    private StereoMode stereoMode;
    private int nbChannels;
    private int nbBins;
    private Cmplx[][] cushion;

    public EdgeExtract() {
        super("audio.effect.spectrum.time.edge-x", "Extract fast amplitude variations");
        super.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setScaleType(ScaleType.LOG2);
        this.inSmoothing.setScaleType(ScaleType.LOG2);
        this.inSensivity.setScaleType(ScaleType.LOG2);
        this.inAttackDelay.setScaleType(ScaleType.LOG2);
        this.inAttackSpeed.setScaleType(ScaleType.LOG2);
        this.inPreset.setSkillType(SkillType.SIMPLIFIED);
        this.inStereoMode.setSkillType(SkillType.NORMAL);
        this.inThreshold.setSkillType(SkillType.ADVANCED);
        this.inSensivity.setSkillType(SkillType.ADVANCED);
        this.inSmoothing.setSkillType(SkillType.ADVANCED);
        this.inMinSpan.setSkillType(SkillType.ADVANCED);
        this.inHard.setSkillType(SkillType.ADVANCED);
        this.inSpread.setSkillType(SkillType.ADVANCED);
        this.inAttackDelay.setSkillType(SkillType.ADVANCED);
        this.inAttackSpeed.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outShort;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outLong;
    }

    @Override
    public void setup() {
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        if (this.nbChannels != audio.nbChannels || this.nbBins != audio.nbBins || this.inStereoMode.isModified() || this.inThreshold.isModified() || this.inSmoothing.isModified() || this.inSensivity.isModified() || this.inAttackSpeed.isModified() || this.inAttackDelay.isModified() || this.inMinSpan.isModified() || this.inSpread.isModified() || this.inHard.isModified() || this.inMaxJump.isModified()) {
            int avgLength;
            this.nbChannels = audio.nbChannels;
            this.nbBins = audio.nbBins;
            double threshold = (Double)this.inThreshold.read();
            int length = (int)(threshold / audio.getRealDuration() + 0.5);
            if (length < 1) {
                length = 1;
            }
            if ((avgLength = (int)((Double)this.inSmoothing.read() / audio.getRealDuration() + 0.5)) < 1) {
                avgLength = 1;
            }
            int attackDelay = (int)((Double)this.inAttackDelay.read() / audio.getRealDuration() + 0.5);
            float maxJump = (float)AudioMath.dbToLevel((Double)this.inMaxJump.read());
            this.stereoMode = this.inStereoMode.read();
            if (this.stereoMode == StereoMode.Independent) {
                this.extractor = null;
                this.extractors = new EdgeExtractor[audio.nbChannels];
                int i = 0;
                while (i < audio.nbChannels) {
                    this.extractors[i] = new EdgeExtractor(1, audio.nbBins, length, avgLength, (Double)this.inSensivity.read(), attackDelay, (Double)this.inAttackSpeed.read(), (Integer)this.inMinSpan.read(), (Integer)this.inSpread.read(), (Boolean)this.inHard.read(), false, maxJump);
                    ++i;
                }
            } else {
                this.extractor = new EdgeExtractor(audio.nbChannels, audio.nbBins, length, avgLength, (Double)this.inSensivity.read(), attackDelay, (Double)this.inAttackSpeed.read(), (Integer)this.inMinSpan.read(), (Integer)this.inSpread.read(), (Boolean)this.inHard.read(), this.stereoMode == StereoMode.SplitLock, maxJump);
                this.extractors = null;
            }
        }
    }

    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] shortx, Cmplx[] longx) {
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        if (this.extractors != null) {
            if (this.cushion == null) {
                this.cushion = new Cmplx[1][];
            }
            this.cushion[0] = input;
            this.extractors[chan].analyzeMixed(this.cushion);
            this.extractors[chan].processMixed(input, 0, shortx, longx);
        } else {
            if (chan == 0 && this.extractor != null) {
                if (this.stereoMode == StereoMode.SplitLock) {
                    this.extractor.analyseSplitted(audio.data);
                } else {
                    this.extractor.analyzeMixed(audio.data);
                }
            }
            if (this.stereoMode == StereoMode.SplitLock) {
                this.extractor.processSplitted(audio.data[chan], chan, shortx, longx);
            } else {
                this.extractor.processMixed(audio.data[chan], chan, shortx, longx);
            }
        }
    }

    public static enum Preset implements Presetter<EdgeExtract>
    {
        Short{

            @Override
            public void apply(EdgeExtract bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p128);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inThreshold, 0.017);
                setter.setPortValue(bouncelet.inSmoothing, 0.014);
                setter.setPortValue(bouncelet.inSensivity, 5.0);
                setter.setPortValue(bouncelet.inAttackDelay, 0.0);
                setter.setPortValue(bouncelet.inAttackSpeed, 1.0);
                setter.setPortValue(bouncelet.inMinSpan, 10);
                setter.setPortValue(bouncelet.inSpread, 3);
            }
        }
        ,
        Transients{

            @Override
            public void apply(EdgeExtract bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p128);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inThreshold, 0.1);
                setter.setPortValue(bouncelet.inSmoothing, 0.03);
                setter.setPortValue(bouncelet.inSensivity, 5.0);
                setter.setPortValue(bouncelet.inAttackDelay, 0.0);
                setter.setPortValue(bouncelet.inAttackSpeed, 15.0);
                setter.setPortValue(bouncelet.inMinSpan, 20);
                setter.setPortValue(bouncelet.inSpread, 0);
            }
        }
        ,
        Long{

            @Override
            public void apply(EdgeExtract bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p512);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inThreshold, 0.069);
                setter.setPortValue(bouncelet.inSmoothing, 0.057);
                setter.setPortValue(bouncelet.inSensivity, 5.0);
                setter.setPortValue(bouncelet.inAttackDelay, 0.0);
                setter.setPortValue(bouncelet.inAttackSpeed, 3.0);
                setter.setPortValue(bouncelet.inMinSpan, 10);
                setter.setPortValue(bouncelet.inSpread, 3);
            }
        };

    }

    public static enum StereoMode {
        Independent("Independent"),
        MixedLock("Mixed Lock"),
        SplitLock("Split Lock");

        private String name;

        private StereoMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

