/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public class Smooth
extends AudioExtractSpectrumBouncelet {
    private static final double BASE_FACTOR = 375.0;
    private static final double BASE_RATIO = 1.1223;
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inRatio = new InDouble("ratio", "Smooth ratio", 4.0, 0.0, 10.0);
    public InBoolean inAttack = new InBoolean("attack", "Smooth attacks", true);
    public InBoolean inDecay = new InBoolean("decay", "Smooth decays", true);
    public InBoolean inFast = new InBoolean("fast", "Use fast approximations", true);
    public OutSpectrum outSmooth = new OutSpectrum("out.smooth", "Smoothed audio spectrum");
    public OutSpectrum outRough = new OutSpectrum("out.rough", "Roughed audio spectrum");
    private double factor;
    private int nbChannels = 0;
    private int nbBins = 0;
    private double[][] state;

    public Smooth() {
        super("audio.effect.spectrum.time.smooth", "Smooth frequency curves over time");
        super.setSkillType(SkillType.ADVANCED);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inFast.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected OutSpectrum getOutput1() {
        return this.outSmooth;
    }

    @Override
    protected OutSpectrum getOutput2() {
        return this.outRough;
    }

    @Override
    public void setup() {
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        if (spectrum.nbBins != this.nbBins || spectrum.nbChannels != this.nbChannels) {
            this.nbBins = spectrum.nbBins;
            this.nbChannels = spectrum.nbChannels;
            this.state = new double[spectrum.nbChannels][this.nbBins];
        }
        if (this.inRatio.isModified()) {
            this.factor = Math.pow(0.5, (Double)this.inRatio.read() + 1.1223);
            this.factor = this.factor * 375.0 * spectrum.getRealDuration();
        }
    }

    @Override
    public void process(int chan, Cmplx[] input, Cmplx[] smooth, Cmplx[] rough) {
        boolean attacks = (Boolean)this.inAttack.read();
        boolean decays = (Boolean)this.inDecay.read();
        boolean fast = (Boolean)this.inFast.read();
        double[] state = this.state[chan];
        int i = 0;
        while (i < input.length) {
            double norm = fast ? input[i].magApprox() : input[i].mag();
            double delta = norm - state[i];
            if (delta > 0.0 && attacks) {
                delta *= this.factor;
            } else if (delta < 0.0 && decays) {
                delta *= this.factor;
            }
            double newNorm = state[i] + delta;
            if (newNorm < 0.0) {
                newNorm = 0.0;
            }
            double ratio = norm > 0.001 ? newNorm / norm : 1.0;
            smooth[i].set(input[i]);
            smooth[i].mul((float)ratio);
            rough[i].set(input[i]);
            rough[i].mul((float)(1.0 - ratio));
            state[i] = newNorm;
            ++i;
        }
    }
}

