/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.analysis.Formants;
import org.corebounce.decklight.bouncelets.audio.convert.channels.ToMulti;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.filter.Shaper;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.GhostTwin;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public abstract class CrossSynthesisWaveBouncelet
extends MacroBouncelet
implements GhostTwin {
    protected final ToMulti toStereo = new ToMulti();
    protected final WaveToSpectrum wave2SpectrumT = new WaveToSpectrum();
    protected final Formants spectralShape = new Formants();
    protected final Shaper shaper = new Shaper();
    private final BounceletBase[] parts = new BounceletBase[]{this.toStereo, this.wave2SpectrumT, this.spectralShape, this.shaper};

    public CrossSynthesisWaveBouncelet(String name, String description) {
        super(name, description);
    }

    protected abstract OutAudio getToneOut();

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.getToneOut(), this.toStereo.inAudio);
        connector.connect(this.toStereo.outAudio, this.wave2SpectrumT.inAudio());
        connector.connect(this.spectralShape.outShape, this.shaper.inShape);
        connector.connect(this.wave2SpectrumT.outSpectrum(), this.shaper.inSpectrum);
        super.createDeepInternalConnections(connector, this.getFlatParts());
    }

    protected abstract InputPort<?>[] getXInputPorts();

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        InputPort<?>[] xports = this.getXInputPorts();
        InputPort[] result = new InputPort[xports.length + 1];
        result[0] = this.spectralShape.inSpectrum;
        System.arraycopy(xports, 0, result, 1, xports.length);
        return result;
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.shaper.outSpectrum};
    }

    protected abstract BounceletBase[] getXParts();

    private BounceletBase[] getFlatParts() {
        BounceletBase[] xparts = this.getXParts();
        BounceletBase[] result = new BounceletBase[xparts.length + this.parts.length];
        System.arraycopy(this.parts, 0, result, 0, this.parts.length);
        System.arraycopy(xparts, 0, result, this.parts.length, xparts.length);
        return result;
    }

    @Override
    public BounceletBase[] getParts() {
        return super.getDeepParts(this.getFlatParts());
    }

    @Override
    public WaveToSpectrum[] getTwins() {
        return new WaveToSpectrum[]{this.wave2SpectrumT};
    }
}

