/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import java.util.Random;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Distance
extends Bouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InSpectrumPreset<Distance, Presets> inPresets = new InSpectrumPreset(Presets.class, "distance", "Distance of the sound", Presets.Medium);
    public InDouble inPhasiness = new InDouble("phasiness", "Amount of phasiness", 1.0, 0.0, 1.0);
    public InDouble inStereoSkew = new InDouble("stereo", "Amount of stereo loss", 0.25, 0.0, 1.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private Cmplx[][] rotations;

    public Distance() {
        super("audio.effect.spectrum.tone.distance", "Increases the sound's distance", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inPresets.setSkillType(SkillType.SIMPLIFIED);
        this.inPhasiness.setSkillType(SkillType.ADVANCED);
        this.inStereoSkew.setSkillType(SkillType.NORMAL);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        boolean changes;
        SpectrumData source = (SpectrumData)this.inAudio.peek();
        boolean bl = changes = this.inPhasiness.isModified() || this.inStereoSkew.isModified();
        if (this.rotations == null || this.rotations.length != source.nbChannels || this.rotations[0].length != source.nbBins) {
            changes = true;
            this.rotations = Cmplx.newArray(source.nbChannels, source.nbBins);
        }
        if (changes) {
            Random rnd = new Random();
            double phasiness = (Double)this.inPhasiness.read();
            double stereoLoss = (Double)this.inStereoSkew.read();
            int i = 0;
            while (i < this.rotations[0].length) {
                double phase = (rnd.nextDouble() - 0.5) * Math.PI * 2.0 * phasiness;
                this.rotations[0][i].set((float)Math.cos(phase), (float)Math.sin(phase));
                int c = 1;
                while (c < this.rotations.length) {
                    double skew = (rnd.nextDouble() - 0.5) * Math.PI * 2.0 * stereoLoss;
                    this.rotations[c][i].set((float)Math.cos(phase + skew), (float)Math.sin(phase + skew));
                    ++c;
                }
                ++i;
            }
        }
    }

    private void process() {
        SpectrumData src = (SpectrumData)this.inAudio.read();
        this.outAudio.prepare(src);
        SpectrumData dst = (SpectrumData)this.outAudio.get();
        int chan = 0;
        while (chan < src.nbChannels) {
            Cmplx[] input = src.data[chan];
            Cmplx[] output = dst.data[chan];
            output[0].set(input[0]);
            output[input.length - 1].set(input[input.length - 1]);
            int i = 1;
            while (i < input.length - 1) {
                output[i].set(input[i]);
                output[i].mul(this.rotations[chan][i]);
                ++i;
            }
            ++chan;
        }
    }

    public static enum Presets implements Presetter<Distance>
    {
        Zero("Zero (inactive)"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setPortValue(bouncelet.inPhasiness, 0.0);
                setter.setPortValue(bouncelet.inStereoSkew, 0.0);
            }
        }
        ,
        VeryLow("Very low"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setPortValue(bouncelet.inPhasiness, 0.25);
                setter.setPortValue(bouncelet.inStereoSkew, 0.0);
            }
        }
        ,
        Low("Low"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setPortValue(bouncelet.inPhasiness, 0.5);
                setter.setPortValue(bouncelet.inStereoSkew, 0.0);
            }
        }
        ,
        Medium("Medium"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p2048);
                setter.setPortValue(bouncelet.inPhasiness, 1.0);
                setter.setPortValue(bouncelet.inStereoSkew, 0.25);
            }
        }
        ,
        High("High"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p4096);
                setter.setPortValue(bouncelet.inPhasiness, 1.0);
                setter.setPortValue(bouncelet.inStereoSkew, 0.5);
            }
        }
        ,
        VeryHigh("Very high"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p8192);
                setter.setPortValue(bouncelet.inPhasiness, 1.0);
                setter.setPortValue(bouncelet.inStereoSkew, 0.75);
            }
        }
        ,
        ExtremelyHigh("Extremely high"){

            @Override
            public void apply(Distance bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p16384);
                setter.setPortValue(bouncelet.inPhasiness, 1.0);
                setter.setPortValue(bouncelet.inStereoSkew, 1.0);
            }
        };

        private final String name;

        private Presets(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

