/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import org.corebounce.common.dsp.fft.UnityRoots;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Log;

public class Helicopter
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inData = new InSpectrum("in", "Input audio spectrum");
    public InDouble inSpeed = new InDouble("speed", "Helicopter speed [Hz]", 12.0, 0.1, 100.0);
    public OutSpectrum outData = new OutSpectrum("out", "Output audio spectrum");
    private int nbPhases0;
    private int curPhase0;
    private int nbPhases1;
    private int curPhase1;
    private Cmplx[] roots;

    public Helicopter() {
        super("audio.effect.spectrum.tone.helicopter", "Set all Fourier frequencies to the same phase", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inSpeed.setScaleType(ScaleType.CUBEROOT);
        this.inSpeed.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    protected void setup() {
        if (this.inSpeed.isModified()) {
            double speed = (Double)this.inSpeed.read();
            SpectrumData data = (SpectrumData)this.inData.peek();
            this.nbPhases1 = (int)(1.0 / speed / data.getRealDuration());
            this.nbPhases0 = data.windowing.getOverlapping().intValue();
            this.nbPhases1 /= this.nbPhases0;
            if (this.nbPhases1 < 1) {
                this.nbPhases1 = 1;
            }
            Log.debug("Using {0}*{1} phases", this.nbPhases1, this.nbPhases0);
            this.roots = UnityRoots.getInstance().getRoots(this.nbPhases0 * this.nbPhases1, this.nbPhases0 * this.nbPhases1);
        }
    }

    @Override
    public void cycle() {
        super.cycle();
        --this.curPhase0;
        if (this.curPhase0 < 0) {
            this.curPhase0 += this.nbPhases0;
            --this.curPhase1;
            if (this.curPhase1 < 0) {
                this.curPhase1 += this.nbPhases1;
            }
        }
    }

    @Override
    public void process(Cmplx[] input, Cmplx[] output) {
        assert (input.length == output.length);
        int i = 0;
        while (i < input.length) {
            float mag = input[i].magApprox();
            output[i].set(mag * 2.0f, 0.0f);
            int phase = this.curPhase0 + this.curPhase1 * this.nbPhases0;
            int shift = phase * i % (this.nbPhases0 * this.nbPhases1);
            output[i].mul(this.roots[shift]);
            ++i;
        }
    }
}

