/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.SpectrumToFrequencies;
import org.corebounce.decklight.bouncelets.audio.convert.format.SpectrumToWave;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.convert.format.advanced.FrequenciesToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.base.Volume;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.Detune;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bouncelets.signal.Sub;
import org.corebounce.decklight.bouncelets.signal.values.Double;
import org.corebounce.decklight.bouncelets.signal.values.PowerOfTwo;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public class PhaseVocoder
extends MacroBouncelet {
    private final Double shift = new Double("shift", "frequency shift", (double)AudioConfig.getSampleRate() / 512.0, 0.0, 512.0);
    private final PowerOfTwo blockSize = new PowerOfTwo("blockSize", "FFT Size", PowerOf2.p1024, PowerOf2.p256, PowerOf2.p2048);
    private final Detune detuneIn = new Detune();
    private final WaveToSpectrum wave2spectrum = new WaveToSpectrum();
    private final SpectrumToFrequencies spectrum2freqs = new SpectrumToFrequencies();
    private final FrequenciesToSpectrum freqs2spectrum = new FrequenciesToSpectrum();
    private final SpectrumToWave spectrum2wave = new SpectrumToWave();
    private final Sub sub = new Sub();
    private final Detune detuneOut = new Detune();
    private final Volume volume = new Volume();
    private final BounceletBase[] parts = new BounceletBase[]{this.shift, this.blockSize, this.detuneIn, this.wave2spectrum, this.spectrum2freqs, this.freqs2spectrum, this.spectrum2wave, this.sub, this.detuneOut, this.volume};

    public PhaseVocoder() {
        super("audio.effect.fourier.tone.phase-vocoder", "Phase Vocoder");
        super.setSkillType(SkillType.NORMAL);
        this.shift.inDouble.setSkillType(SkillType.NORMAL);
        this.blockSize.inData.setSkillType(SkillType.NORMAL);
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.shift.outDouble, this.detuneIn.inShift);
        connector.connect(this.detuneIn.outAudio, this.wave2spectrum.inAudio());
        connector.connect(this.wave2spectrum.outSpectrum(), this.spectrum2freqs.inSpectrum);
        connector.connect(this.spectrum2freqs.outFreqs, this.freqs2spectrum.inFreqs);
        connector.connect(this.freqs2spectrum.outSpectrum, this.spectrum2wave.inSpectrum());
        connector.connect(this.spectrum2wave.outAudio(), this.detuneOut.inAudio);
        connector.connect(this.detuneOut.outAudio, this.volume.inAudio);
        connector.connect(this.shift.outDouble, this.sub.inValue2);
        connector.connect(this.sub.outResult, this.detuneOut.inShift);
        connector.connect(this.blockSize.outData, this.wave2spectrum.inWindowSize());
        this.shift.inDouble.write((double)AudioConfig.getSampleRate() / 512.0);
        this.sub.inValue1.write(0.0);
        this.wave2spectrum.inOverlap().write(PowerOf2.p4);
        this.freqs2spectrum.inOverlapping.write(PowerOf2.p4);
        this.detuneOut.inFilter.write(false);
        this.volume.inVolume.write(2.0);
        super.createDeepInternalConnections(connector, this.parts);
    }

    public InAudio inAudio() {
        return this.detuneIn.inAudio;
    }

    public OutAudio outAudio() {
        return this.volume.outAudio;
    }

    public InPowerOf2 inBlockSize() {
        return this.blockSize.inData;
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.detuneIn.inAudio, this.blockSize.inData, this.shift.inDouble};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.volume.outAudio};
    }

    @Override
    public BounceletBase[] getParts() {
        return super.getDeepParts(this.parts);
    }
}

