/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import java.util.Random;
import org.corebounce.common.dsp.fft.UnityRoots;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Log;

public class Whisper
extends AudioStateSpectrumBouncelet<Random> {
    public InSpectrum inData = new InSpectrum("in", "Input audio spectrum");
    public InDouble inAmount = new InDouble("amount", "Whisper amount", 0.75, 0.0, 1.0);
    public OutSpectrum outData = new OutSpectrum("out", "Output audio spectrum");
    private static final int NB_ROOTS = 4096;
    private Cmplx[] roots;
    private Cmplx work;
    private WindowInfo windowing;

    public Whisper() {
        super("audio.effect.spectrum.tone.whisper", "Randomize the phases", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inAmount.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void init() {
        super.init();
        this.roots = UnityRoots.getInstance().getRoots(4096, 4096);
        this.work = new Cmplx();
    }

    protected Random[] createStates(int nbChans) {
        Random[] result = new Random[nbChans];
        int i = 0;
        while (i < result.length) {
            result[i] = new Random(0L);
            ++i;
        }
        return result;
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    @Override
    public void setup(boolean changes) {
        super.setup(changes);
        SpectrumData spectrum = (SpectrumData)this.inData.peek();
        if (spectrum.windowing.isWindowModified() || this.inAmount.isModified()) {
            Log.debug("Rebuilding whisper window", new Object[0]);
            float[] inShape = spectrum.windowing.getWindow();
            float[] outShape = new float[inShape.length];
            float weight = (float)((Double)this.inAmount.read()).doubleValue();
            float avg = 0.0f;
            int i = 0;
            while (i < inShape.length) {
                avg += inShape[i];
                ++i;
            }
            avg /= (float)inShape.length;
            i = 0;
            while (i < inShape.length) {
                outShape[i] = avg * weight + inShape[i] * (1.0f - weight);
                ++i;
            }
            this.windowing = new WindowInfo(spectrum.windowing);
            this.windowing.setWindow(outShape);
        } else {
            this.windowing.setWindowModified(false);
        }
    }

    @Override
    public void process(Random state, int chan, Cmplx[] input, Cmplx[] output) {
        block5: {
            float amount;
            block6: {
                block4: {
                    assert (input.length == output.length);
                    output[0].set(input[0]);
                    output[output.length - 1].set(input[output.length - 1]);
                    amount = (float)((Double)this.inAmount.read()).doubleValue();
                    if (amount != 1.0f) break block4;
                    int i = 1;
                    while (i < output.length - 1) {
                        output[i].set(input[i]);
                        int phase = state.nextInt(4096);
                        output[i].mul(this.roots[phase]);
                        ++i;
                    }
                    break block5;
                }
                if (amount != 0.0f) break block6;
                if (input == output) break block5;
                int i = 0;
                while (i < input.length) {
                    output[i].set(input[i]);
                    ++i;
                }
                break block5;
            }
            float keep = 1.0f - amount;
            int i = 1;
            while (i < output.length - 1) {
                this.work.set(input[i]);
                int phase = state.nextInt(4096);
                this.work.mul(this.roots[phase]);
                output[i].set(input[i].re * keep + this.work.re * amount, input[i].im * keep + this.work.im * amount);
                ++i;
            }
        }
    }
}

