/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.echo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Severity;

public class CenterEcho
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Audio input wave");
    public InDouble inLeft = new InDouble("delay.left", "Left channel echo delay [s]", 0.3, 0.0, 2.0);
    public InDouble inRight = new InDouble("delay.right", "Right channel echo delay [s]", 0.25, 0.0, 2.0);
    public InDouble inForw = new InDouble("level.forw", "Echo level on same channel", 0.1, -1.0, 1.0);
    public InDouble inRev = new InDouble("level.rev", "Echo level on other channel", 0.5, -1.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Audio output wave");
    private Buffer leftBuffer;
    private Buffer rightBuffer;
    private double correction;

    public CenterEcho() {
        super("audio.effect.wave.echo.center-echo", "Echo from the sides toward the center");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inLeft.setScaleType(ScaleType.LOG2);
        this.inRight.setScaleType(ScaleType.LOG2);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        int size;
        if (this.inLeft.isModified()) {
            size = (int)((Double)this.inLeft.read() * (double)AudioConfig.getSampleRate());
            if (size < 1) {
                size = 1;
            }
            if (this.leftBuffer == null) {
                this.leftBuffer = new Buffer(size);
            } else {
                this.leftBuffer.setSize(size);
            }
        }
        if (this.inRight.isModified()) {
            size = (int)((Double)this.inLeft.read() * (double)AudioConfig.getSampleRate());
            if (size < 1) {
                size = 1;
            }
            if (this.rightBuffer == null) {
                this.rightBuffer = new Buffer(size);
            } else {
                this.rightBuffer.setSize(size);
            }
        }
        if (this.inForw.isModified() || this.inRev.isModified()) {
            double volume;
            double rev;
            double forw = Math.abs((Double)this.inForw.peek());
            double total = forw + (rev = Math.abs((Double)this.inRev.peek()));
            if (total >= 1.0) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "The echo is unstable. Sum of levels {0} >= 1", total);
                volume = 100.0;
            } else {
                volume = 1.0 / (1.0 - total);
            }
            this.correction = 2.0 / (volume + 1.0);
        }
    }

    private void process() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(2, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        double forw = (Double)this.inForw.read();
        double rev = (Double)this.inRev.read();
        float[] leftInput = inWave.data[0];
        float[] rightInput = inWave.nbChannels < 2 ? inWave.data[0] : inWave.data[1];
        float[] leftOutput = outWave.data[0];
        float[] rightOutput = outWave.data[1];
        int i = 0;
        while (i < inWave.nbFrames) {
            double inl = (double)leftInput[i] * this.correction;
            double inr = (double)rightInput[i] * this.correction;
            double echl = this.leftBuffer.peek();
            double echr = this.rightBuffer.peek();
            double outl = inl + echl * forw + echr * rev;
            double outr = inr + echr * forw + echl * rev;
            this.leftBuffer.push(outl);
            this.rightBuffer.push(outr);
            leftOutput[i] = (float)outl;
            rightOutput[i] = (float)outr;
            ++i;
        }
    }
}

