/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.echo;

import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.echo.EchoEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Log;
import org.corebounce.utils.Severity;

public class Echo
extends AudioStateWaveBouncelet<EchoEngine> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inSourceLevel = new InDouble("in.level", "Source level", 0.5, -1.0, 1.0);
    public InDouble inForw1Delay = new InDouble("forw1.delay", "Nonrecursive echo delay 1", 0.1, 0.0, 1.0);
    public InDouble inForw1Level = new InDouble("forw1.level", "Nonrecursive echo level 1", 0.0, -1.0, 1.0);
    public InDouble inForw2Delay = new InDouble("forw2.delay", "Nonrecursive echo delay 2", 0.17, 0.0, 1.0);
    public InDouble inForw2Level = new InDouble("forw2.level", "Nonrecursive echo level 2", 0.0, -1.0, 1.0);
    public InDouble inForw3Delay = new InDouble("forw3.delay", "Nonrecursive echo delay 3", 0.22, 0.0, 1.0);
    public InDouble inForw3Level = new InDouble("forw3.level", "Nonrecursive echo level 3", 0.0, -1.0, 1.0);
    public InDouble inForw4Delay = new InDouble("forw4.delay", "Nonrecursive echo delay 4", 0.31, 0.0, 1.0);
    public InDouble inForw4Level = new InDouble("forw4.level", "Nonrecursive echo level 4", 0.0, -1.0, 1.0);
    public InDouble inBack1Delay = new InDouble("back1.delay", "Recursive echo delay 1", 0.1, 0.0, 1.0);
    public InDouble inBack1Level = new InDouble("back1.level", "Recursive echo level 1", 0.0, -1.0, 1.0);
    public InDouble inBack2Delay = new InDouble("back2.delay", "Recursive echo delay 2", 0.17, 0.0, 1.0);
    public InDouble inBack2Level = new InDouble("back2.level", "Recursive echo level 2", 0.0, -1.0, 1.0);
    public InDouble inBack3Delay = new InDouble("back3.delay", "Recursive echo delay 3", 0.22, 0.0, 1.0);
    public InDouble inBack3Level = new InDouble("back3.level", "Recursive echo level 3", 0.0, -1.0, 1.0);
    public InDouble inBack4Delay = new InDouble("back4.delay", "Recursive echo delay 4", 0.31, 0.0, 1.0);
    public InDouble inBack4Level = new InDouble("back4.level", "Recursive echo level 4", 0.0, -1.0, 1.0);
    public InBoolean inAutoGain = new InBoolean("autogain", "Automatic gain correction", true);
    private InDouble[] inForwDelay = new InDouble[]{this.inForw1Delay, this.inForw2Delay, this.inForw3Delay, this.inForw4Delay};
    private InDouble[] inForwLevel = new InDouble[]{this.inForw1Level, this.inForw2Level, this.inForw3Level, this.inForw4Level};
    private InDouble[] inBackDelay = new InDouble[]{this.inBack1Delay, this.inBack2Delay, this.inBack3Delay, this.inBack4Delay};
    private InDouble[] inBackLevel = new InDouble[]{this.inBack1Level, this.inBack2Level, this.inBack3Level, this.inBack4Level};
    private final int[] forwDelay = new int[4];
    private final double[] forwLevel = new double[4];
    private final int[] backDelay = new int[4];
    private final double[] backLevel = new double[4];
    private double correction = 1.0;
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public Echo() {
        super("audio.effect.wave.echo.x-echo", "4-tap recursive and 4-tap nonrecursive echos", true);
        InDouble inDelay;
        super.setSkillType(SkillType.SIMPLIFIED);
        InDouble[] inDoubleArray = this.inForwDelay;
        int n = this.inForwDelay.length;
        int n2 = 0;
        while (n2 < n) {
            inDelay = inDoubleArray[n2];
            inDelay.setScaleType(ScaleType.LOG2);
            ++n2;
        }
        inDoubleArray = this.inBackDelay;
        n = this.inBackDelay.length;
        n2 = 0;
        while (n2 < n) {
            inDelay = inDoubleArray[n2];
            inDelay.setScaleType(ScaleType.LOG2);
            ++n2;
        }
        int i = 0;
        while (i < 4) {
            this.inForwDelay[i].setSkillType(SkillType.ADVANCED);
            this.inForwLevel[i].setSkillType(SkillType.ADVANCED);
            this.inBackDelay[i].setSkillType(SkillType.ADVANCED);
            this.inBackLevel[i].setSkillType(SkillType.ADVANCED);
            ++i;
        }
        this.inBack1Delay.setSkillType(SkillType.SIMPLIFIED);
        this.inBack1Level.setSkillType(SkillType.SIMPLIFIED);
        this.inBack2Delay.setSkillType(SkillType.SIMPLIFIED);
        this.inBack2Level.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    protected EchoEngine[] createStates(int nbChans) {
        int sampleCount = AudioConfig.getSampleRate();
        EchoEngine[] result = new EchoEngine[nbChans];
        int i = 0;
        while (i < nbChans) {
            result[i] = new EchoEngine(sampleCount);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        int sampleRate = AudioConfig.getSampleRate();
        int i = 0;
        while (i < 4) {
            if (this.inForwDelay[i].isModified()) {
                this.forwDelay[i] = (int)((Double)this.inForwDelay[i].read() * (double)sampleRate + 0.5);
                if (this.forwDelay[i] >= sampleRate) {
                    this.forwDelay[i] = sampleRate - 1;
                }
            }
            if (this.inForwLevel[i].isModified()) {
                this.forwLevel[i] = (Double)this.inForwLevel[i].read();
                changes = true;
            }
            if (this.inBackDelay[i].isModified()) {
                this.backDelay[i] = (int)((Double)this.inBackDelay[i].read() * (double)sampleRate + 0.5);
                if (this.backDelay[i] < 0) {
                    this.backDelay[i] = 0;
                }
            }
            if (this.inBackLevel[i].isModified()) {
                this.backLevel[i] = (Double)this.inBackLevel[i].read();
                changes = true;
            }
            ++i;
        }
        if (changes) {
            if (((Boolean)this.inAutoGain.read()).booleanValue()) {
                double sum = Math.abs((Double)this.inSourceLevel.read());
                int t = 0;
                while (t < 4) {
                    sum += Math.abs(this.forwLevel[t]);
                    ++t;
                }
                double backSum = 0.0;
                int t2 = 0;
                while (t2 < 4) {
                    backSum += Math.abs(this.backLevel[t2]);
                    ++t2;
                }
                if (backSum >= 1.0) {
                    super.log(GraphErrorType.IllegalArgument, Severity.Warning, "The echo is unstable. Sum of backward levels {0} >= 1", backSum);
                    sum += 100.0;
                } else {
                    sum += 1.0 / (1.0 - backSum) - 1.0;
                }
                this.correction = (1.0 + 1.0 / sum) / 2.0;
                Log.debug("Echo correction: {0}", this.correction);
            } else {
                this.correction = 1.0;
            }
        }
    }

    @Override
    public void process(EchoEngine state, float[] input, float[] output) {
        double sourceLevel = (Double)this.inSourceLevel.read();
        int i = 0;
        while (i < output.length) {
            double out = (double)input[i] * sourceLevel;
            state.pushInput(input[i]);
            int t = 0;
            while (t < 4) {
                double forw = state.getPastInput(this.forwDelay[t]) * this.forwLevel[t];
                out += forw;
                double back = state.getPastOutput(this.backDelay[t]) * this.backLevel[t];
                out += back;
                ++t;
            }
            state.pushOutput(out);
            output[i] = (float)(out * this.correction);
            ++i;
        }
    }
}

