/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.ButterworthEngine;

public class DjEngine {
    private final double lowFrequencyCut;
    private final double highFrequencyCut;
    private final ButterworthEngine lowpass;
    private final ButterworthEngine highpass;
    private float prevLowLevel = 1.0f;
    private float prevMidLevel = 1.0f;
    private float prevHighLevel = 1.0f;
    private float lowLevel = 1.0f;
    private float midLevel = 1.0f;
    private float highLevel = 1.0f;

    public DjEngine(double lowFrequencyCut, double highFrequencyCut) {
        this.lowFrequencyCut = lowFrequencyCut;
        this.highFrequencyCut = highFrequencyCut;
        this.lowpass = ButterworthEngine.getLowpassFilter(lowFrequencyCut);
        this.highpass = ButterworthEngine.getHighpassFilter(highFrequencyCut);
    }

    public double getLowFrequencyCut() {
        return this.lowFrequencyCut;
    }

    public double getHighFrequencyCut() {
        return this.highFrequencyCut;
    }

    public float getLowLevel() {
        return this.lowLevel;
    }

    public void setLowLevel(float lowLevel) {
        this.prevLowLevel = this.lowLevel;
        this.lowLevel = lowLevel;
    }

    public float getMidLevel() {
        return this.midLevel;
    }

    public void setMidLevel(float medLevel) {
        this.prevMidLevel = this.midLevel;
        this.midLevel = medLevel;
    }

    public float getHighLevel() {
        return this.highLevel;
    }

    public void setHighLevel(float highLevel) {
        this.prevHighLevel = this.highLevel;
        this.highLevel = highLevel;
    }

    public void apply(float[] input, float[] output) {
        assert (input.length == output.length);
        float curLowLevel = this.prevLowLevel;
        float curMidLevel = this.prevMidLevel;
        float curHighLevel = this.prevHighLevel;
        float incLowLevel = (this.lowLevel - this.prevLowLevel) / (float)input.length;
        float incMidLevel = (this.midLevel - this.prevMidLevel) / (float)input.length;
        float incHighLevel = (this.highLevel - this.prevHighLevel) / (float)input.length;
        int i = 0;
        while (i < input.length) {
            float sample = input[i];
            float low = this.lowpass.process(sample);
            float high = this.highpass.process(sample);
            float mid = sample - low - high;
            output[i] = low * curLowLevel + high * curHighLevel + mid * curMidLevel;
            curLowLevel += incLowLevel;
            curMidLevel += incMidLevel;
            curHighLevel += incHighLevel;
            ++i;
        }
    }

    public void split(float[] input, float[] lowOut, float[] midOut, float[] highOut) {
        int i = 0;
        while (i < input.length) {
            float sample = input[i];
            float low = this.lowpass.process(sample);
            float high = this.highpass.process(sample);
            float mid = sample - low - high;
            lowOut[i] = low;
            midOut[i] = mid;
            highOut[i] = high;
            ++i;
        }
    }

    public void sledgehammer(float[] input, float[] output, float boost, float retain) {
        assert (input.length == output.length);
        int i = 0;
        while (i < input.length) {
            float sample = input[i];
            float low = this.lowpass.process(sample);
            float high = this.highpass.process(sample);
            float mid = sample - low - high;
            output[i] = 0.5f * retain * low + (0.5f + low * boost) * mid + 0.5f * high;
            ++i;
        }
    }
}

