/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.ButterworthEngine;

public class EqualizerEngine {
    private static final double CORRECTION = (double)0.7f;
    private double baseGainBeg;
    private double baseGainEnd;
    private ButterworthEngine[] filters;
    private double[] filterGainsBeg;
    private double[] filterGainsEnd;

    public EqualizerEngine(ButterworthEngine[] filters, double[] filterGains, double baseGain) {
        assert (filters.length == filterGains.length);
        this.filters = filters;
        this.filterGainsBeg = filterGains;
        this.filterGainsEnd = filterGains;
        this.baseGainBeg = baseGain;
        this.baseGainEnd = baseGain;
    }

    public double getBaseGainBeg() {
        return this.baseGainBeg;
    }

    public double getBaseGainEnd() {
        return this.baseGainEnd;
    }

    public ButterworthEngine[] getFilters() {
        return this.filters;
    }

    public double[] getBegGains() {
        return this.filterGainsBeg;
    }

    public double[] getEndGains() {
        return this.filterGainsEnd;
    }

    public void update(double newBaseGain, double[] newFilterGains) {
        this.baseGainBeg = this.baseGainEnd;
        this.baseGainEnd = newBaseGain;
        this.filterGainsBeg = this.filterGainsEnd;
        this.filterGainsEnd = newFilterGains;
    }

    public void update() {
        this.baseGainBeg = this.baseGainEnd;
        this.filterGainsBeg = this.filterGainsEnd;
    }

    public void apply(float[] input, float[] output) {
        double begGain = this.getBaseGainBeg();
        double endGain = this.getBaseGainEnd();
        double incr = (endGain - begGain) / (double)input.length;
        int i = 0;
        while (i < input.length) {
            output[i] = input[i] * (float)begGain;
            begGain += incr;
            ++i;
        }
        ButterworthEngine[] filters = this.getFilters();
        double[] begGains = this.getBegGains();
        double[] endGains = this.getEndGains();
        assert (begGains.length == endGains.length);
        assert (filters.length == endGains.length);
        int i2 = 0;
        while (i2 < filters.length) {
            filters[i2].processWeighted(input, output, (float)(begGains[i2] * (double)0.7f), (float)(endGains[i2] * (double)0.7f));
            ++i2;
        }
        this.update();
    }

    public void split(float[] input, float[][] bands) {
        assert (bands.length == this.filters.length);
        float correction = (float)this.filters.length / 2.0f;
        double begGain = this.getBaseGainBeg();
        double endGain = this.getBaseGainEnd();
        double incr = (endGain - begGain) / (double)input.length;
        int i = 0;
        while (i < input.length) {
            int b = 0;
            while (b < this.filters.length) {
                bands[b][i] = input[i] * (float)begGain * correction;
                ++b;
            }
            begGain += incr;
            ++i;
        }
        ButterworthEngine[] filters = this.getFilters();
        double[] begGains = this.getBegGains();
        double[] endGains = this.getEndGains();
        assert (begGains.length == endGains.length);
        assert (filters.length == endGains.length);
        int b = 0;
        while (b < filters.length) {
            filters[b].processWeighted(input, bands[b], (float)(begGains[b] * (double)0.7f * (double)correction), (float)(endGains[b] * (double)0.7f * (double)correction));
            ++b;
        }
        this.update();
    }
}

