/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class HighFilter
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private float[] last;

    public HighFilter() {
        super("audio.effect.wave.filter.highfilter", "Filter high frequencies");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        if (this.outAudio.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing)) {
            this.last = new float[inWave.nbChannels];
        }
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < inWave.nbChannels) {
            float[] input = inWave.data[chan];
            float[] output = outWave.data[chan];
            float prev = this.last[chan];
            int i = 0;
            while (i < input.length) {
                output[i] = (input[i] + prev) / 2.0f;
                prev = input[i];
                ++i;
            }
            this.last[chan] = prev;
            ++chan;
        }
    }
}

