/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.HilbertEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class Hilbert
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public OutAudio outAudioRe = new OutAudio("re", "Output Audio Wave (+45\u00b0)");
    public OutAudio outAudioIm = new OutAudio("im", "Output Audio Wave (-45\u00b0)");
    private HilbertEngine[] engines;

    public Hilbert() {
        super("audio.effect.wave.filter.hilbert", "Hilbert transform");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        if (this.engines == null || this.engines.length != inWave.nbChannels) {
            this.engines = new HilbertEngine[inWave.nbChannels];
            int i = 0;
            while (i < this.engines.length) {
                this.engines[i] = new HilbertEngine(AudioConfig.getSampleRate());
                ++i;
            }
        }
        this.outAudioRe.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        this.outAudioIm.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        int chan = 0;
        while (chan < inWave.nbChannels) {
            float[] input = inWave.data[chan];
            float[] outRe = ((WaveData)this.outAudioRe.get()).data[chan];
            float[] outIm = ((WaveData)this.outAudioIm.get()).data[chan];
            this.engines[chan].process(input, outRe, outIm);
            ++chan;
        }
    }
}

