/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.FilterEngine;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.FilterType;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;

public class LowpassFilter
extends AudioStateWaveBouncelet<FilterEngine> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inFrequency = new InDouble("frequency", "Band center frequency [Hz]", 700.0, FilterEngine.getMinFrequency(), FilterEngine.getMaxFrequency());
    public InInt inStrength = new InInt("strength", "Filter strength", 2, 1, 5);
    public InputPort<FilterType> inType = new InputPort<FilterType>(FilterType.class, "type", "Filter type", FilterType.Butterworth);
    public InDouble inRipple = new InDouble("ripple", "Pass-band ripple (Chebyshev1) [dB]", 1.0, 0.0, 10.0);
    public InDouble inAttenuation = new InDouble("attenuation", "Stop-band attenuation (Chebyshev2) [dB]", -60.0, -100.0, -1.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public LowpassFilter() {
        super("audio.effect.wave.filter.lowpass", "Lowpass filter", true);
        super.setSkillType(SkillType.NORMAL);
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
        this.inType.setSkillType(SkillType.ADVANCED);
        this.inRipple.setSkillType(SkillType.ADVANCED);
        this.inAttenuation.setSkillType(SkillType.ADVANCED);
    }

    protected FilterEngine[] createStates(int nbChans) {
        boolean sweep = !this.inStrength.isModified() && !this.inType.isModified() && !this.inRipple.isModified() && !this.inAttenuation.isModified();
        FilterEngine[] prev = (FilterEngine[])this.states;
        FilterEngine[] result = new FilterEngine[nbChans];
        double frequency = (Double)this.inFrequency.read();
        double ripple = (Double)this.inRipple.read();
        double attenuation = (Double)this.inAttenuation.read();
        double sampleRate = AudioConfig.getSampleRate();
        int i = 0;
        while (i < result.length) {
            result[i] = new FilterEngine((Integer)this.inStrength.read() * 2);
            switch (this.inType.read()) {
                case Butterworth: {
                    result[i].initButterworthLow(sampleRate, frequency);
                    break;
                }
                case Chebyshev1: {
                    result[i].initChebyshev1Low(sampleRate, frequency, ripple);
                    break;
                }
                case Chebyshev2: {
                    result[i].initChebyshev2Low(sampleRate, frequency, attenuation);
                }
            }
            if (sweep && prev != null && prev.length == result.length && prev[i].getNbSections() == result[i].getNbSections()) {
                result[i].copyHistory(prev[i]);
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean checkForChanges() {
        return this.inFrequency.isModified() || this.inStrength.isModified() || this.inType.isModified() || this.inRipple.isModified() || this.inAttenuation.isModified();
    }

    @Override
    public void process(FilterEngine state, float[] input, float[] output) {
        state.process(input, output);
    }
}

