/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.DjEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Sledgehammer
extends AudioStateWaveBouncelet<DjEngine> {
    public InAudio inAudio = new InAudio("in", "Audio input wave");
    public InDouble inLowCut = new InDouble("Low Cut", "Lowpass cutoff frequency [Hz]", 250.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inHighCut = new InDouble("High Cut", "Highpass cutoff frequency [Hz]", 3000.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inBoost = new InDouble("boost", "Modulation depth", 3.0, 0.0, 6.0);
    public InDouble inRetain = new InDouble("retain", "Amount of bass to retain", 0.0, 0.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public Sledgehammer() {
        super("audio.effect.wave.filter.sledgehammer", "Extract low frequencies to modulate middle-low frequencies", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inLowCut.setScaleType(ScaleType.LOG2);
        this.inHighCut.setScaleType(ScaleType.LOG2);
        this.inLowCut.setSkillType(SkillType.SIMPLIFIED);
        this.inHighCut.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return this.inLowCut.isModified() || this.inHighCut.isModified();
    }

    protected DjEngine[] createStates(int nbChans) {
        double lowFrequencyCut = (Double)this.inLowCut.read();
        double highFrequencyCut = (Double)this.inHighCut.read();
        DjEngine[] result = new DjEngine[nbChans];
        int c = 0;
        while (c < nbChans) {
            result[c] = new DjEngine(lowFrequencyCut, highFrequencyCut);
            ++c;
        }
        return result;
    }

    @Override
    public void process(DjEngine state, float[] input, float[] output) {
        assert (input.length == output.length);
        state.sledgehammer(input, output, (float)((Double)this.inBoost.read()).doubleValue(), (float)((Double)this.inRetain.read()).doubleValue());
    }
}

