/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter.flow;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.ButterworthEngine;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.EqualizerEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public class BandSplitter
extends Bouncelet {
    private final double[] frequencies = new double[]{86.0, 172.0, 345.0, 689.0, 1378.0, 2756.0, 5512.0, 8764.0, 13935.0};
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inBand0 = new InDouble("band0", "[0-43 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand1 = new InDouble("band1", "[43-86 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand2 = new InDouble("band2", "[86-172 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand3 = new InDouble("band3", "[172-345 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand4 = new InDouble("band4", "[345-689 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand5 = new InDouble("band5", "[689-1378 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand6 = new InDouble("band6", "[1378-2756 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand7 = new InDouble("band7", "[2756-5512 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand8 = new InDouble("band8", "[5512-11025 Hz]", 0.0, -100.0, 20.0);
    public InDouble inBand9 = new InDouble("band9", "[11025-22050 Hz]", 0.0, -100.0, 20.0);
    public InBoolean inZeroFlat = new InBoolean("zeroflat", "Force zero phase response when flat", false);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave (contains 10 times the number of channels of the input audio wave)");
    private InDouble[] inBands = new InDouble[]{this.inBand0, this.inBand1, this.inBand2, this.inBand3, this.inBand4, this.inBand5, this.inBand6, this.inBand7, this.inBand8, this.inBand9};
    private EqualizerEngine[] states;
    private float[][] outChan;

    public BandSplitter() {
        super("audio.effect.wave.filter.flow.bandsplit", "Ten band butterworth-based splitter");
        super.setSkillType(SkillType.ADVANCED);
        InDouble[] inDoubleArray = this.inBands;
        int n = this.inBands.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inBand = inDoubleArray[n2];
            inBand.setSkillType(SkillType.ADVANCED);
            ++n2;
        }
    }

    public InDouble getBand(int i) {
        return this.inBands[i];
    }

    private boolean checkForChanges() {
        InDouble[] inDoubleArray = this.inBands;
        int n = this.inBands.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inBand = inDoubleArray[n2];
            if (inBand.isModified()) {
                return true;
            }
            ++n2;
        }
        return this.inZeroFlat.isModified();
    }

    private EqualizerEngine[] createStates(int nbChans) {
        double baseGain = (Boolean)this.inZeroFlat.read() != false ? Double.POSITIVE_INFINITY : 0.0;
        double[] gains = new double[10];
        int i = 0;
        while (i < 10) {
            gains[i] = AudioMath.dbToLevel((Double)this.inBands[i].read());
            if (gains[i] < baseGain) {
                baseGain = gains[i];
            }
            ++i;
        }
        i = 0;
        while (i < 10) {
            gains[i] = gains[i] - baseGain;
            ++i;
        }
        EqualizerEngine[] result = this.states;
        if (result == null) {
            result = new EqualizerEngine[nbChans];
            int c = 0;
            while (c < nbChans) {
                ButterworthEngine[] filters = new ButterworthEngine[10];
                filters[0] = ButterworthEngine.getBandpassFilter(1.0, this.frequencies[0]);
                int i2 = 1;
                while (i2 < 9) {
                    filters[i2] = ButterworthEngine.getBandpassFilter(this.frequencies[i2 - 1], this.frequencies[i2]);
                    ++i2;
                }
                filters[9] = ButterworthEngine.getBandpassFilter(this.frequencies[8], AudioConfig.MAX_FREQUENCY);
                result[c] = new EqualizerEngine(filters, gains, baseGain);
                ++c;
            }
        } else {
            int c = 0;
            while (c < nbChans) {
                result[c].update(baseGain, gains);
                ++c;
            }
        }
        return result;
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        if (this.states == null || this.states.length != inWave.nbChannels || this.checkForChanges()) {
            this.states = this.createStates(inWave.nbChannels);
        }
        int outChannels = inWave.nbChannels * this.inBands.length;
        this.outAudio.prepare(outChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < inWave.nbChannels) {
            if (this.outChan == null) {
                this.outChan = new float[this.inBands.length][];
            }
            int i = 0;
            while (i < this.inBands.length) {
                this.outChan[i] = outWave.data[chan * this.inBands.length + i];
                ++i;
            }
            this.states[chan].split(inWave.data[chan], this.outChan);
            ++chan;
        }
    }
}

