/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.DetuneEngine2;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Detune2
extends Bouncelet {
    public InAudio inAudio1 = new InAudio("in1", "1st Input Audio Wave");
    public InAudio inAudio2 = new InAudio("in2", "2nd Input Audio Wave");
    public InDouble inShift = new InDouble("shift", "Frequency shift amount [Hz]", 0.0, -1000.0, 1000.0);
    public OutAudio outAudio = new OutAudio("out", "Output Audio wave");
    private DetuneEngine2[] engines;

    public Detune2() {
        super("audio.effect.wave.pitch.detune2", "Detune by shifting the frequencies", true);
        super.setSkillType(SkillType.EXPERT);
        this.inShift.setScaleType(ScaleType.CUBEROOT);
        this.inShift.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        WaveData wave = (WaveData)this.inAudio1.peek();
        if (this.engines == null || this.engines.length != wave.nbChannels) {
            this.engines = new DetuneEngine2[wave.nbChannels];
            int i = 0;
            while (i < this.engines.length) {
                this.engines[i] = new DetuneEngine2(AudioConfig.getSampleRate());
                ++i;
            }
            this.setupEngines();
        } else if (this.inShift.isModified()) {
            this.setupEngines();
        }
    }

    private void setupEngines() {
        DetuneEngine2[] detuneEngine2Array = this.engines;
        int n = this.engines.length;
        int n2 = 0;
        while (n2 < n) {
            DetuneEngine2 engine = detuneEngine2Array[n2];
            engine.setShift((Double)this.inShift.read());
            ++n2;
        }
    }

    private void process() {
        WaveData inWave1 = (WaveData)this.inAudio1.read();
        WaveData inWave2 = (WaveData)this.inAudio2.read();
        this.outAudio.prepare(Math.min(inWave1.nbChannels, inWave2.nbChannels), Math.min(inWave1.nbFrames, inWave2.nbFrames), inWave1.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < outWave.nbChannels) {
            float[] input1 = inWave1.data[chan];
            float[] input2 = inWave2.data[chan];
            float[] output = outWave.data[chan];
            this.engines[chan].process(input1, input2, output);
            ++chan;
        }
    }
}

