/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.math.FastMath;

public class DetuneEngine2 {
    private static final int RESET_COUNTDOWN = 10000;
    private final double sampleRate;
    private double rate;
    private double angle;
    private double sinAngle;
    private double cosAngle;
    private double sinRate;
    private double cosRate;
    private int countDown;
    private boolean down;

    public DetuneEngine2(double sampleRate) {
        this.sampleRate = sampleRate;
        this.countDown = 10000;
    }

    public void setShift(double shift) {
        boolean down;
        boolean bl = down = shift < 0.0;
        if (down != this.down && (this.cosAngle != 0.0 || this.sinAngle != 0.0)) {
            this.angle = Math.atan2(this.cosAngle, this.sinAngle);
        }
        this.down = down;
        this.rate = Math.PI * 2 * Math.abs(shift) / this.sampleRate;
        this.sinAngle = Math.sin(this.angle);
        this.cosAngle = Math.cos(this.angle);
        this.sinRate = Math.sin(this.rate);
        this.cosRate = Math.cos(this.rate);
    }

    public void process(float[] input1, float[] input2, float[] output) {
        if (input1.length != input2.length || input1.length != output.length) {
            throw new IllegalArgumentException();
        }
        float[] inp1 = this.down ? input1 : input2;
        float[] inp2 = this.down ? input2 : input1;
        int i = 0;
        while (i < output.length) {
            output[i] = inp1[i] * (float)this.sinAngle + inp2[i] * (float)this.cosAngle;
            this.updateModulators();
            ++i;
        }
    }

    private void updateModulators() {
        this.angle += this.rate;
        if (this.countDown <= 0) {
            this.angle = FastMath.wrap(this.angle);
            this.sinAngle = Math.sin(this.angle);
            this.cosAngle = Math.cos(this.angle);
            this.countDown = 10000;
        } else {
            double nextSin = this.sinAngle * this.cosRate + this.cosAngle * this.sinRate;
            double nextCos = this.cosAngle * this.cosRate - this.sinAngle * this.sinRate;
            this.sinAngle = nextSin;
            this.cosAngle = nextCos;
            --this.countDown;
        }
    }
}

