/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.ButterworthEngine;

public class FilterBank {
    private final double lower;
    private final double upper;
    private final int size;
    private final ButterworthEngine[][] engines;
    private final double[] lowers;
    private final double[] uppers;
    private final double[] centers;

    public FilterBank(double lower, double upper, int size, int strength, double minBandWidth) {
        if (lower >= upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
        this.size = size;
        this.engines = new ButterworthEngine[size][strength];
        this.centers = new double[size];
        this.lowers = new double[size];
        this.uppers = new double[size];
        double logLower = Math.log(lower);
        double logUpper = Math.log(upper);
        double logLast = logLower;
        int i = 0;
        while (i < size) {
            double logStart = logLast;
            double logStop = logLast + (logUpper - logLast) / (double)(size - i);
            double start = Math.exp(logStart);
            double stop = Math.exp(logStop);
            if (stop - start < minBandWidth) {
                stop = start + minBandWidth;
                logStop = Math.log(stop);
            }
            this.centers[i] = Math.exp((logStart + logStop) / 2.0);
            this.lowers[i] = start;
            this.uppers[i] = stop;
            int j = 0;
            while (j < strength) {
                this.engines[i][j] = ButterworthEngine.getBandpassFilter(this.lowers[i], this.uppers[i]);
                ++j;
            }
            logLast = logStop;
            ++i;
        }
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public int getSize() {
        return this.size;
    }

    public double getLowerFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.lowers[band];
    }

    public double getCenterFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.centers[band];
    }

    public double getUpperFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.uppers[band];
    }

    public void process(float[] input, float[] output, int band) {
        int i;
        if (input.length != output.length) {
            throw new IllegalArgumentException();
        }
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException("'band' must be in the [0..size] range");
        }
        if (input != output) {
            i = 0;
            while (i < input.length) {
                output[i] = input[i];
                ++i;
            }
        }
        i = 0;
        while (i < this.engines[band].length) {
            this.engines[band][i].processBand(output);
            ++i;
        }
    }
}

