/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.FilterEngine;

public class FilterBank2 {
    private final double lower;
    private final double upper;
    private final int size;
    private final FilterEngine[] engines;
    private final double[] lowers;
    private final double[] uppers;
    private final double[] centers;

    public FilterBank2(double lower, double upper, int size, int strength, double minBandWidth) {
        if (lower >= upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
        this.size = size;
        this.engines = new FilterEngine[size];
        this.centers = new double[size];
        this.lowers = new double[size];
        this.uppers = new double[size];
        double logLower = Math.log(lower);
        double logUpper = Math.log(upper);
        double logLast = logLower;
        int i = 0;
        while (i < size) {
            double logStart = logLast;
            double logStop = logLast + (logUpper - logLast) / (double)(size - i);
            double start = Math.exp(logStart);
            double stop = Math.exp(logStop);
            if (stop - start < minBandWidth) {
                stop = start + minBandWidth;
                logStop = Math.log(stop);
            }
            this.centers[i] = Math.exp((logStart + logStop) / 2.0);
            this.lowers[i] = start;
            this.uppers[i] = stop;
            this.engines[i] = new FilterEngine(20);
            double skew = 1.003;
            this.engines[i].initChebyshev1Band(AudioConfig.getSampleRate(), this.lowers[i] * skew, this.uppers[i] / skew, 1.0);
            logLast = logStop;
            ++i;
        }
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public int getSize() {
        return this.size;
    }

    public double getLowerFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.lowers[band];
    }

    public double getCenterFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.centers[band];
    }

    public double getUpperFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.uppers[band];
    }

    public void process(float[] input, float[] output, int band) {
        if (input.length != output.length) {
            throw new IllegalArgumentException();
        }
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException("'band' must be in the [0..size] range");
        }
        if (input != output) {
            int i = 0;
            while (i < input.length) {
                output[i] = input[i];
                ++i;
            }
        }
        this.engines[band].process(output, output);
    }
}

