/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.convert.format.BlockSize;
import org.corebounce.decklight.bouncelets.audio.effect.base.Gain;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.PitchShiftRollers;
import org.corebounce.decklight.bouncelets.audio.flow.Mixer;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public class Miserablize
extends MacroBouncelet {
    private final Gain initGain = new Gain();
    private final BlockSize bSize1 = new BlockSize();
    private final Mixer mixer = new Mixer();
    private final PitchShiftRollers pitchShift = new PitchShiftRollers();
    private final Gain feedbackGain = new Gain();
    private final BounceletBase[] parts = new BounceletBase[]{this.initGain, this.bSize1, this.mixer, this.pitchShift, this.feedbackGain};

    public Miserablize() {
        super("audio.effect.wave.pitch.miserablize", "Turn happy sounds :-) into miserable ones :-(");
        super.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.initGain.outAudio, this.bSize1.inAudio);
        connector.connect(this.bSize1.outAudio, this.mixer.inAudio0);
        connector.connect(this.mixer.outAudio, this.pitchShift.inAudio);
        connector.connect(this.pitchShift.outAudio, this.feedbackGain.inAudio);
        connector.connect(this.feedbackGain.outAudio, this.mixer.inAudio1);
        super.createDeepInternalConnections(connector, this.parts);
        this.initGain.inGain.write(-7.0);
        this.bSize1.inBlockSize.write(PowerOf2.p32);
        this.mixer.inNormalized.write(false);
        this.pitchShift.inRatio.write(0.99);
        this.pitchShift.inMinBandWidth.write(10.0);
        this.pitchShift.inQuality.write(36);
        this.feedbackGain.inGain.write(-2.0);
    }

    public void setAudioBlockType(PowerOf2 blockSize, int nbChannels) {
        this.bSize1.inBlockSize.write(blockSize);
        WaveData data = new WaveData(nbChannels, blockSize.intValue());
        this.mixer.inAudio0.write(data);
        this.mixer.inAudio1.write(data);
        Port.transfer(this.mixer.inAudio0, this.mixer.outAudio);
    }

    public InAudio inAudio() {
        return this.initGain.inAudio;
    }

    public OutAudio outAudio() {
        return this.mixer.outAudio;
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.initGain.inAudio};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.mixer.outAudio};
    }

    @Override
    public BounceletBase[] getParts() {
        return super.getDeepParts(this.parts);
    }
}

