/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.base.DCBlockEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Octaver
extends AudioStateWaveBouncelet<DCBlockEngine> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inStrength = new InDouble("strength", "Strength", 0.5, 0.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private float posRatio;
    private float negRatio;

    public Octaver() {
        super("audio.effect.wave.pitch.octaver", "Mix with ocatve-pitched versions", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inStrength.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    protected DCBlockEngine[] createStates(int nbChans) {
        DCBlockEngine[] result = new DCBlockEngine[nbChans];
        int i = 0;
        while (i < result.length) {
            result[i] = new DCBlockEngine(0.9999);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        super.setup(changes);
        if (this.inStrength.isModified()) {
            float wet = (float)((Double)this.inStrength.read()).doubleValue();
            float dry = 1.0f - wet;
            wet = (float)Math.sqrt(wet);
            dry = (float)Math.sqrt(dry);
            this.posRatio = dry + wet;
            this.negRatio = dry - wet;
        }
    }

    @Override
    public void process(DCBlockEngine state, float[] input, float[] output) {
        if (input.length != output.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < input.length) {
            float v = input[i];
            input[i] = v >= 0.0f ? v * this.posRatio : v * this.negRatio;
            ++i;
        }
        state.process(input, output);
    }
}

