/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.PitchShiftRollersEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class PitchShiftRollers
extends AudioStateWaveBouncelet<PitchShiftRollersEngine> {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InDouble inRatio = new InDouble("ratio", "Ratio between desired and original pitches", 1.0, 0.5, 2.0);
    public InInt inQuality = new InInt("resolution", "Tuning resolution", 100, 30, 200);
    public InDouble inMinBandWidth = new InDouble("minwidth", "Minimum bandwidth (time vs frequency resolution)", 50.0, 1.0, 100.0);
    public OutAudio outAudio = new OutAudio("out", "Output Audio wave");

    public PitchShiftRollers() {
        super("audio.effect.wave.pitch.pitchshift-rollers", "Change the musical pitch without affecting the speed");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio.setScaleType(ScaleType.LOG2);
        this.inQuality.setSkillType(SkillType.ADVANCED);
        this.inMinBandWidth.setSkillType(SkillType.ADVANCED);
        this.inMinBandWidth.setScaleType(ScaleType.LINEAR);
    }

    @Override
    public boolean checkForChanges() {
        return this.inRatio.isModified() || this.inQuality.isModified() || this.inMinBandWidth.isModified();
    }

    protected PitchShiftRollersEngine[] createStates(int nbChans) {
        WaveData wave = (WaveData)this.inAudio.peek();
        double ratio = (Double)this.inRatio.read();
        PitchShiftRollersEngine[] engines = new PitchShiftRollersEngine[nbChans];
        int i = 0;
        while (i < nbChans) {
            engines[i] = new PitchShiftRollersEngine(wave.nbFrames, ratio, (Integer)this.inQuality.read(), 4, (Double)this.inMinBandWidth.read());
            ++i;
        }
        return engines;
    }

    @Override
    public void process(PitchShiftRollersEngine state, float[] input, float[] output) {
        state.process(input, output);
    }
}

