/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import java.util.Arrays;
import java.util.Random;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.HilbertEngine;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.DetuneEngine;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.FilterBank;

public class PitchShiftRollersEngine {
    private static final double MIN_AUDIBLE_TUNE = 16.0;
    private static final double MAX_AUDIBLE_TUNE = 22000.0;
    private static final float CORRECTION = 1.4f;
    private static final float THRESHOLD = (float)AudioMath.dbToLevel(-120.0);
    private final double ratio;
    private final int bankSize;
    private final HilbertEngine hilbert;
    private final FilterBank filterBank1;
    private final FilterBank filterBank2;
    private final DetuneEngine[] detuneEngines;
    private final float[] hilbertBuffer1;
    private final float[] hilbertBuffer2;
    private final float[] bandBuffer1;
    private final float[] bandBuffer2;
    private final Random rnd = new Random();

    public PitchShiftRollersEngine(int bufferSize, double ratio, int bankSize, int analysisStrength, double minBandWidth) {
        this.ratio = ratio;
        this.bankSize = bankSize;
        double sampleRate = AudioConfig.getSampleRate();
        this.hilbert = new HilbertEngine(sampleRate);
        double lower = ratio > 1.0 ? 16.0 : 16.0 / ratio;
        double upper = ratio < 1.0 ? 22000.0 : 22000.0 / ratio;
        this.filterBank1 = new FilterBank(lower, upper, bankSize, analysisStrength, minBandWidth);
        this.filterBank2 = new FilterBank(lower, upper, bankSize, analysisStrength, minBandWidth);
        this.detuneEngines = new DetuneEngine[bankSize];
        int i = 0;
        while (i < bankSize) {
            double srcFreq = this.filterBank1.getCenterFrequency(i);
            double dstFreq = srcFreq * ratio;
            double shift = dstFreq - srcFreq;
            this.detuneEngines[i] = new DetuneEngine(sampleRate, bufferSize, 0);
            this.detuneEngines[i].setShift(shift);
            ++i;
        }
        this.hilbertBuffer1 = new float[bufferSize];
        this.hilbertBuffer2 = new float[bufferSize];
        this.bandBuffer1 = new float[bufferSize];
        this.bandBuffer2 = new float[bufferSize];
    }

    public double getRatio() {
        return this.ratio;
    }

    public void process(float[] input, float[] output) {
        if (input == output) {
            throw new IllegalArgumentException("Cannot perform in-place");
        }
        if (input.length != output.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < input.length) {
            int n = i++;
            input[n] = input[n] + (this.rnd.nextFloat() - 0.5f) * THRESHOLD;
        }
        Arrays.fill(output, 0.0f);
        this.hilbert.process(input, this.hilbertBuffer1, this.hilbertBuffer2);
        int band = 0;
        while (band < this.bankSize) {
            this.filterBank1.process(this.hilbertBuffer1, this.bandBuffer1, band);
            this.filterBank2.process(this.hilbertBuffer2, this.bandBuffer2, band);
            this.detuneEngines[band].process(this.bandBuffer1, this.bandBuffer2, this.bandBuffer1);
            int i2 = 0;
            while (i2 < output.length) {
                int n = i2;
                output[n] = output[n] + this.bandBuffer1[i2] * 1.4f;
                ++i2;
            }
            ++band;
        }
    }
}

