/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.math.FastMath;

public class RingEngine {
    private static final double AVERAGE_GAIN = 0.6366197723675814;
    private static final float CORRECTION = (float)Math.sqrt(2.0);
    private static final double PHASE_OFFSET = Math.asin(0.6366197723675814);
    private final double sampleRate;
    private double rate;
    private double angle = PHASE_OFFSET;

    public RingEngine(double sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setShift(double shift) {
        this.rate = Math.abs(shift) * (Math.PI * 2) / this.sampleRate;
        if (shift == 0.0) {
            this.angle = PHASE_OFFSET;
        }
    }

    public void apply(float[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = buffer[i] * (float)FastMath.fastSin0(this.angle) * CORRECTION;
            this.angle += this.rate;
            if (this.angle > Math.PI) {
                this.angle -= Math.PI * 2;
            }
            ++i;
        }
    }
}

