/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.RingEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class RingModulation
extends AudioStateWaveBouncelet<RingEngine> {
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InDouble inShift = new InDouble("shift", "frequency shift [Hz]", 0.0, 0.0, AudioConfig.MAX_FREQUENCY / 2.0);
    public OutAudio outAudio = new OutAudio("out", "Output Audio wave");

    public RingModulation() {
        super("audio.effect.wave.pitch.ring", "Ring modulation", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inShift.setScaleType(ScaleType.CUBEROOT);
        this.inShift.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    protected RingEngine[] createStates(int nbChans) {
        RingEngine[] result = new RingEngine[nbChans];
        double shift = (Double)this.inShift.read();
        int i = 0;
        while (i < nbChans) {
            result[i] = new RingEngine(AudioConfig.getSampleRate());
            this.setup(result[i], shift);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        super.setup(changes);
        if (this.inShift.isModified() && this.states != null) {
            double shift = (Double)this.inShift.read();
            int i = 0;
            while (i < ((RingEngine[])this.states).length) {
                this.setup(((RingEngine[])this.states)[i], shift);
                ++i;
            }
        }
    }

    private void setup(RingEngine engine, double shift) {
        engine.setShift(shift);
    }

    @Override
    public void process(RingEngine state, float[] input, float[] output) {
        if (input != output) {
            System.arraycopy(input, 0, output, 0, input.length);
        }
        state.apply(output);
    }
}

