/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.WeaverEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public class WeaverDetune
extends AudioStateWaveBouncelet<WeaverEngine> {
    private static final int STRENGTH = 5;
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InDouble inShift = new InDouble("shift", "Frequency shift amount [Hz]", 0.0, 0.0, AudioConfig.MAX_FREQUENCY / 4.0);
    public InBoolean inFilter = new InBoolean("filter", "Filter wrapped frequencies", true);
    public OutAudio outAudio = new OutAudio("out", "Output Audio wave");

    public WeaverDetune() {
        super("audio.effect.wave.pitch.weaver-detune", "Detune by shifting the frequencies both up and down", true);
        super.setSkillType(SkillType.ADVANCED);
        this.inShift.setScaleType(ScaleType.CUBEROOT);
        this.inShift.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return false;
    }

    protected WeaverEngine[] createStates(int nbChans) {
        WaveData wave = (WaveData)this.inAudio.peek();
        WeaverEngine[] result = new WeaverEngine[nbChans];
        double shift = (Double)this.inShift.read();
        int i = 0;
        while (i < nbChans) {
            result[i] = new WeaverEngine(AudioConfig.getSampleRate(), wave.nbFrames, 5);
            this.setup(result[i], shift);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        super.setup(changes);
        if (this.inShift.isModified() && this.states != null) {
            double shift = (Double)this.inShift.read();
            int i = 0;
            while (i < ((WeaverEngine[])this.states).length) {
                this.setup(((WeaverEngine[])this.states)[i], shift);
                ++i;
            }
        }
    }

    private void setup(WeaverEngine engine, double shift) {
        engine.setShift(shift);
    }

    @Override
    public void process(WeaverEngine state, float[] input, float[] output) {
        state.process(input, output, (Boolean)this.inFilter.read());
    }
}

