/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.stereo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Pan
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inPan = new InDouble("pan", "Balance position, 0=front, +1=right, -1=left, \u00b12=rear", 0.0, -4.0, 4.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public Pan() {
        super("audio.effect.wave.stereo.pan", "Stereo panning");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inPan.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void cycle() {
        boolean phaseReverseR;
        boolean phaseReverseL;
        WaveData inWave = (WaveData)this.inAudio.read();
        int nbChannels = inWave.nbChannels;
        if (nbChannels < 2) {
            nbChannels = 2;
        }
        this.outAudio.prepare(nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        double panL = (Double)this.inPan.read() - 1.0;
        if (panL < -4.0) {
            panL += 8.0;
        }
        boolean bl = phaseReverseL = Math.abs(panL) > 2.0;
        if (panL > 2.0) {
            panL -= 4.0;
        } else if (panL < -2.0) {
            panL += 4.0;
        }
        double minPanZeroL = panL < 0.0 ? panL : 0.0;
        double maxPanZeroL = panL > 0.0 ? panL : 0.0;
        double panR = (Double)this.inPan.read() + 1.0;
        if (panR > 4.0) {
            panR -= 8.0;
        }
        boolean bl2 = phaseReverseR = Math.abs(panR) > 2.0;
        if (panR > 2.0) {
            panR -= 4.0;
        } else if (panR < -2.0) {
            panR += 4.0;
        }
        double minPanZeroR = panR < 0.0 ? panR : 0.0;
        double maxPanZeroR = panR > 0.0 ? panR : 0.0;
        float[] input1 = inWave.data[0 % inWave.nbChannels];
        float[] input2 = inWave.data[1 % inWave.nbChannels];
        float[] output1 = outWave.data[0];
        float[] output2 = outWave.data[1];
        int i = 0;
        while (i < outWave.nbFrames) {
            float inL = input1[i];
            if (phaseReverseL) {
                output1[i] = (float)(-(1.0 - maxPanZeroL) * (double)inL / 2.0);
                output2[i] = (float)(-(1.0 + minPanZeroL) * (double)inL / 2.0);
            } else {
                output1[i] = (float)((1.0 - maxPanZeroL) * (double)inL / 2.0);
                output2[i] = (float)((1.0 + minPanZeroL) * (double)inL / 2.0);
            }
            float inR = input2[i];
            if (phaseReverseR) {
                int n = i;
                output1[n] = output1[n] + (float)(-(1.0 - maxPanZeroR) * (double)inR / 2.0);
                int n2 = i;
                output2[n2] = output2[n2] + (float)(-(1.0 + minPanZeroR) * (double)inR / 2.0);
            } else {
                int n = i;
                output1[n] = output1[n] + (float)((1.0 - maxPanZeroR) * (double)inR / 2.0);
                int n3 = i;
                output2[n3] = output2[n3] + (float)((1.0 + minPanZeroR) * (double)inR / 2.0);
            }
            ++i;
        }
        int chan = 2;
        while (chan < outWave.nbChannels) {
            int i2 = 0;
            while (i2 < outWave.nbFrames) {
                outWave.data[chan][i2] = inWave.data[chan][i2];
                ++i2;
            }
            ++chan;
        }
    }
}

