/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.stereo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class StereoExpand
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inFactor = new InDouble("factor", "Expansion factor", 0.25, 0.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public StereoExpand() {
        super("audio.effect.wave.stereo.stereoexpand", "Expand the stereo image");
        this.inFactor.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        if (inWave.nbChannels >= 2) {
            double factor = (Double)this.inFactor.read();
            double correction = 1.0 / (1.0 + factor);
            float[] inputChan1 = inWave.data[0];
            float[] inputChan2 = inWave.data[1];
            float[] outputChan1 = outWave.data[0];
            float[] outputChan2 = outWave.data[1];
            int i = 0;
            while (i < inWave.nbFrames) {
                double samp1 = inputChan1[i];
                double samp2 = inputChan2[i];
                outputChan1[i] = (float)((samp1 - samp2 * factor) * correction);
                outputChan2[i] = (float)((samp2 - samp1 * factor) * correction);
                ++i;
            }
        }
    }
}

