/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.time;

import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Delay
extends AudioStateWaveBouncelet<Buffer> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inDelay = new InDouble("delay", "Amount of delay", 0.1, 0.0, 5.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private int samplesDelay;

    public Delay() {
        super("audio.effect.wave.time.delay", "Delay the audio wave", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inDelay.setScaleType(ScaleType.LOG2);
        this.inDelay.setSkillType(SkillType.SIMPLIFIED);
    }

    protected Delay(String name, String description) {
        super(name, description, true);
    }

    @Override
    public boolean checkForChanges() {
        return this.inDelay.isModified();
    }

    protected Buffer[] createStates(int nbChans) {
        double delay = (Double)this.inDelay.read();
        this.samplesDelay = (int)(delay * (double)AudioConfig.getSampleRate() + 0.5);
        Buffer[] result = new Buffer[nbChans];
        int i = 0;
        while (i < nbChans) {
            if (this.states != null && i < ((Buffer[])this.states).length) {
                result[i] = ((Buffer[])this.states)[i];
                result[i].setSize(this.samplesDelay);
            } else {
                result[i] = new Buffer(this.samplesDelay);
            }
            ++i;
        }
        return result;
    }

    @Override
    public void process(Buffer state, float[] input, float[] output) {
        if (input != output) {
            assert (input.length == output.length);
            System.arraycopy(input, 0, output, 0, input.length);
        }
        state.pushArray(output);
    }
}

