/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.flow;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.utils.Severity;

public class Mixer
extends Bouncelet {
    public InAudio inAudio0 = new InAudio("in0", "Input audio wave 0");
    public InAudio inAudio1 = new InAudio("in1", "Input audio wave 1");
    public InAudio inAudio2 = new InAudio("in2", "Input audio wave 2");
    public InAudio inAudio3 = new InAudio("in3", "Input audio wave 3");
    public InAudio inAudio4 = new InAudio("in4", "Input audio wave 4");
    public InAudio inAudio5 = new InAudio("in5", "Input audio wave 5");
    public InAudio inAudio6 = new InAudio("in6", "Input audio wave 6");
    public InAudio inAudio7 = new InAudio("in7", "Input audio wave 7");
    public InAudio inAudio8 = new InAudio("in8", "Input audio wave 8");
    public InAudio inAudio9 = new InAudio("in9", "Input audio wave 9");
    public InBoolean inNormalized = new InBoolean("normalized", "Normalize gain", true);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private InAudio[] inAudios = new InAudio[]{this.inAudio0, this.inAudio1, this.inAudio2, this.inAudio3, this.inAudio4, this.inAudio5, this.inAudio6, this.inAudio7, this.inAudio8, this.inAudio9};
    private double correction;
    private int nbChannels;
    private int nbFrames;
    private int nbSources;
    private WindowInfo windowing;

    public Mixer() {
        super("audio.flow.mixer", "Mixing console for up to 10 sources");
        int i = 4;
        while (i < this.inAudios.length) {
            this.inAudios[i].setSkillType(SkillType.NORMAL);
            ++i;
        }
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        boolean changes = false;
        int i = 0;
        while (i < 10) {
            changes |= this.inAudios[i].isModified();
            ++i;
        }
        if (changes || this.inNormalized.isModified()) {
            this.nbFrames = -1;
            this.nbChannels = -1;
            i = 0;
            while (i < 10) {
                if (this.inAudios[i].isConnected()) {
                    WaveData wave = (WaveData)this.inAudios[i].read();
                    if (wave.nbChannels > this.nbChannels) {
                        this.nbChannels = wave.nbChannels;
                    }
                    if (this.nbFrames == -1) {
                        this.nbFrames = wave.nbFrames;
                    } else if (this.nbFrames != wave.nbFrames) {
                        super.log(GraphErrorType.IllegalArgument, Severity.Error, "Sources have different block sizes", new Object[0]);
                    }
                }
                ++i;
            }
            if (this.nbFrames < 0) {
                this.nbFrames = AudioConfig.blockSize();
            }
            if (this.nbChannels < 0) {
                this.nbChannels = 2;
            }
            if (this.windowing == null || this.windowing.windowLength() != this.nbFrames) {
                this.windowing = WindowInfo.noWindow(this.nbFrames);
            }
        }
        this.nbSources = 0;
        i = 0;
        while (i < 10) {
            if (this.inAudios[i].isConnected()) {
                ++this.nbSources;
            }
            ++i;
        }
        this.correction = (Boolean)this.inNormalized.read() != false ? 1.0 / (double)this.nbSources : 1.0;
    }

    private void process() {
        this.outAudio.prepare(this.nbChannels, this.nbFrames, this.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < this.nbChannels) {
            float[] output = outWave.data[chan];
            int i = 0;
            while (i < output.length) {
                output[i] = 0.0f;
                ++i;
            }
            int s = 0;
            while (s < 10) {
                if (this.inAudios[s].isConnected()) {
                    WaveData inWave = (WaveData)this.inAudios[s].read();
                    if (chan < inWave.nbChannels) {
                        float[] input = inWave.data[chan];
                        int length = input.length < output.length ? input.length : output.length;
                        int i2 = 0;
                        while (i2 < length) {
                            int n = i2;
                            output[n] = output[n] + input[i2] * (float)this.correction;
                            ++i2;
                        }
                    }
                }
                ++s;
            }
            ++chan;
        }
    }
}

