/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.flow;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Severity;

public class Synchronize
extends Bouncelet {
    public InAudio inAudio0 = new InAudio("in0", "Input audio wave 0");
    public InAudio inAudio1 = new InAudio("in1", "Input audio wave 1");
    public InAudio inAudio2 = new InAudio("in2", "Input audio wave 2");
    public InAudio inAudio3 = new InAudio("in3", "Input audio wave 3");
    public InAudio inAudio4 = new InAudio("in4", "Input audio wave 4");
    public InAudio inAudio5 = new InAudio("in5", "Input audio wave 5");
    public InAudio inAudio6 = new InAudio("in6", "Input audio wave 6");
    public InAudio inAudio7 = new InAudio("in7", "Input audio wave 7");
    public OutAudio outAudio0 = new OutAudio("out0", "Output audio wave 0");
    public OutAudio outAudio1 = new OutAudio("out1", "Output audio wave 1");
    public OutAudio outAudio2 = new OutAudio("out2", "Output audio wave 2");
    public OutAudio outAudio3 = new OutAudio("out3", "Output audio wave 3");
    public OutAudio outAudio4 = new OutAudio("out4", "Output audio wave 4");
    public OutAudio outAudio5 = new OutAudio("out5", "Output audio wave 5");
    public OutAudio outAudio6 = new OutAudio("out6", "Output audio wave 6");
    public OutAudio outAudio7 = new OutAudio("out7", "Output audio wave 7");
    private InAudio[] inAudios = new InAudio[]{this.inAudio0, this.inAudio1, this.inAudio2, this.inAudio3, this.inAudio4, this.inAudio5, this.inAudio6, this.inAudio7};
    private OutAudio[] outAudios = new OutAudio[]{this.outAudio0, this.outAudio1, this.outAudio2, this.outAudio3, this.outAudio4, this.outAudio5, this.outAudio6, this.outAudio7};
    private int maxLatency = 0;
    private int[] latencies = new int[this.inAudios.length];
    private Buffer[][] buffers = new Buffer[this.inAudios.length][];
    private String name = this.toString();

    public Synchronize() {
        super("audio.flow.synchronize", "Synchronize multiple sources with different latencies");
        int i = 4;
        while (i < this.inAudios.length) {
            this.inAudios[i].setSkillType(SkillType.ADVANCED);
            this.outAudios[i].setSkillType(SkillType.ADVANCED);
            ++i;
        }
    }

    public Synchronize(String name) {
        this();
        this.name = name;
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        this.maxLatency = 0;
        int s = 0;
        while (s < this.inAudios.length) {
            InAudio inAudio = this.inAudios[s];
            int latency = 0;
            if (inAudio.isConnected()) {
                Bouncelet source = inAudio.getSource().getBouncelet();
                latency = source.getFullMaxLatency();
            }
            this.latencies[s] = latency;
            if (latency > this.maxLatency) {
                this.maxLatency = latency;
            }
            ++s;
        }
        int nbChan = ((WaveData)this.inAudios[0].peek()).nbChannels;
        int s2 = 0;
        while (s2 < this.inAudios.length) {
            if (this.inAudios[s2].isConnected()) {
                int delay = this.maxLatency - this.latencies[s2];
                if (delay == 0) {
                    this.buffers[s2] = null;
                } else {
                    int c;
                    boolean dump = false;
                    if (this.buffers[s2] == null || this.buffers[s2].length != nbChan) {
                        this.buffers[s2] = new Buffer[nbChan];
                        c = 0;
                        while (c < nbChan) {
                            this.buffers[s2][c] = new Buffer(delay);
                            ++c;
                        }
                        dump = true;
                    } else if (this.buffers[s2][0].getSize() != delay) {
                        c = 0;
                        while (c < nbChan) {
                            this.buffers[s2][c].setSize(delay);
                            ++c;
                        }
                        dump = true;
                    }
                    if (dump) {
                        this.log(GraphErrorType.Information, Severity.Debug, "Latency fix {0}.{1}: {2}", this.name, s2, delay);
                    }
                }
            }
            ++s2;
        }
    }

    private void process() {
        int s = 0;
        while (s < this.inAudios.length) {
            InAudio inAudio = this.inAudios[s];
            if (inAudio.isConnected()) {
                WaveData inWave = (WaveData)inAudio.read();
                OutAudio outAudio = this.outAudios[s];
                outAudio.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
                WaveData outWave = (WaveData)outAudio.get();
                int chan = 0;
                while (chan < outWave.nbChannels) {
                    Buffer buffer = this.buffers[s] == null ? null : this.buffers[s][chan];
                    float[] input = inWave.data[chan];
                    float[] output = outWave.data[chan];
                    if (buffer == null) {
                        System.arraycopy(input, 0, output, 0, input.length);
                    } else {
                        buffer.pushArray(input, output);
                    }
                    ++chan;
                }
            }
            ++s;
        }
    }

    @Override
    public int getFullMinLatency() {
        return super.getFullMaxLatency();
    }
}

