/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.line;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.corebounce.common.audio.file.AudioFileTypes;
import org.corebounce.common.utils.ClassLoaderUtils;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.audio.convert.Resampler;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.play.EndingSourceBouncelet;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateBouncelet;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InFile;
import org.corebounce.utils.Log;
import org.corebounce.utils.LowThreadFactory;
import org.corebounce.utils.Severity;

public class FileReader
extends Bouncelet
implements Runnable,
Resampler.Source,
PlayStateBouncelet,
EndingSourceBouncelet {
    private static final boolean QUIT_ON_DISPOSE = false;
    public InFile inFile = new InFile("file", "Input file/URL");
    public InDouble inBuffer = new InDouble("buffer", "Buffering length [s]", 0.5, 0.01, 10.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private Thread reader;
    private int nbChannels;
    private AudioInputStream audioStream;
    private int queueSize;
    private volatile BlockingQueue<float[]> buffer;
    private WindowInfo windowing;
    private int countDown;
    private Resampler resampler;
    private float[][] output;
    private boolean isEndOfFile;
    private long startTime = 0L;
    private long nbReadFrames = 0L;
    private PlayState playState = PlayState.STOP;
    private PlayState desiredState = PlayState.STOP;
    private long desiredTime = -1L;
    private boolean isPlayModeModified = false;
    private boolean isRealTime = true;
    private float[][] sampleBuffers;
    private byte[][] dataBuffers;
    private int cycleIndex;

    public FileReader() {
        super("audio.line.file.file-reader", "Read audio from a file or URL");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inFile.setSkillType(SkillType.SIMPLIFIED);
        this.inBuffer.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.play();
        this.handleStateChange();
    }

    public void setRealTime(boolean mode) {
        this.isRealTime = mode;
    }

    private void setup() {
        if (this.inFile.isModified() || this.isPlayModeModified) {
            this.closeFile();
            this.isPlayModeModified = false;
            this.nbChannels = 2;
            if (!this.playState.equals((Object)PlayState.STOP)) {
                this.openFile();
            }
            this.countDown = this.isRealTime ? (int)((Double)this.inBuffer.read() * (double)AudioConfig.getSampleRate() / (double)AudioConfig.blockSize()) : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile() {
        if (this.reader != null) {
            this.reader.interrupt();
            try {
                this.reader.join(1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.reader = null;
            this.buffer = null;
        }
        if (this.audioStream != null) {
            try {
                AudioInputStream ex = this.audioStream;
                synchronized (ex) {
                    this.audioStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.audioStream = null;
        }
        this.resampler = null;
        this.buffer = null;
    }

    private static String fileName(String url) {
        int pos = url.lastIndexOf(47);
        String result = url.substring(pos + 1);
        try {
            return URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile() {
        ClassLoaderUtils.ensureClassPath();
        URL url = (URL)this.inFile.read();
        if (url != null) {
            String fileName = FileReader.fileName(url.toString());
            super.log(GraphErrorType.Information, Severity.Debug, "Opening file {0}", url);
            AudioFormat fileFormat = null;
            AudioFormat targetFormat = null;
            try {
                AudioInputStream fileStream = AudioFileTypes.instance().getAudioInputStream(fileName, url.openStream());
                fileFormat = fileStream.getFormat();
                this.nbChannels = fileFormat.getChannels();
                targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, fileFormat.getSampleRate(), 16, fileFormat.getChannels(), fileFormat.getChannels() * 2, fileFormat.getSampleRate(), false);
                this.audioStream = AudioSystem.getAudioInputStream(targetFormat, fileStream);
                if (AudioConfig.getSampleRate() != (int)(fileFormat.getSampleRate() + 0.5f)) {
                    double ratio = (double)AudioConfig.getSampleRate() / (double)fileFormat.getSampleRate();
                    super.log(GraphErrorType.Information, Severity.Info, "Resampling file \"{0}\" from {1}Hz to {2}Hz", FileReader.fileName(url.getFile()), (int)(fileFormat.getSampleRate() + 0.5f), AudioConfig.getSampleRate());
                    this.resampler = new Resampler(this, ratio, fileFormat.getChannels());
                }
                double blockDuration = (double)AudioConfig.blockSize() / (double)AudioConfig.getSampleRate();
                this.queueSize = (int)((Double)this.inBuffer.read() / blockDuration) + 1;
                Log.debug("Creating queue of {0} buffers", this.queueSize);
                this.buffer = new ArrayBlockingQueue<float[]>(this.queueSize);
                this.isEndOfFile = false;
                this.startTime = -1L;
                this.nbReadFrames = 0L;
                this.reader = LowThreadFactory.getInstance().createThread(this, "FileReader thread", true);
                FileReader fileReader = this;
                synchronized (fileReader) {
                    this.notify();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                super.log(GraphErrorType.ServerError, Severity.Error, "Cannot open source {0}: {1}", FileReader.fileName(url.toString()), ex);
            }
            catch (UnsupportedAudioFileException ex) {
                ex.printStackTrace();
                super.log(GraphErrorType.ServerError, Severity.Error, "Cannot open file {0}: Unsupported file format", FileReader.fileName(url.toString()));
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                super.log(GraphErrorType.ServerError, Severity.Catastroph, "Cannot convert from {0} to {1}: {2}", fileFormat, targetFormat, ex);
            }
        }
    }

    private void play() {
        int nbFrames = AudioConfig.blockSize();
        if (this.windowing == null || this.windowing.windowLength() != nbFrames) {
            this.windowing = WindowInfo.noWindow(nbFrames);
        }
        this.outAudio.prepare(this.nbChannels, nbFrames, this.windowing);
        WaveData wave = (WaveData)this.outAudio.get();
        if (this.countDown > 0 || this.playState != PlayState.PLAY || this.buffer == null) {
            int chan = 0;
            while (chan < wave.nbChannels) {
                float[] out = wave.data[chan];
                Arrays.fill(out, 0.0f);
                ++chan;
            }
            --this.countDown;
        } else {
            if ((double)this.startTime < 0.0) {
                this.startTime = this.getTime();
            }
            if (this.resampler == null) {
                try {
                    float[] data = this.buffer.take();
                    while (data.length != wave.nbFrames * wave.nbChannels) {
                        data = this.buffer.take();
                    }
                    assert (data.length == wave.nbFrames * wave.nbChannels);
                    assert (wave.nbChannels == this.nbChannels);
                    int chan = 0;
                    while (chan < this.nbChannels) {
                        float[] out = wave.data[chan];
                        int src = chan;
                        int dst = 0;
                        while (dst < out.length) {
                            out[dst] = data[src];
                            src += this.nbChannels;
                            ++dst;
                        }
                        ++chan;
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            } else {
                this.resampler.resample(wave.data);
            }
        }
    }

    @Override
    public void dispose() {
        this.closeFile();
        super.dispose();
    }

    private void handleStateChange() {
        if (this.desiredTime >= 0L && this.getTime() >= this.desiredTime) {
            this.setPlayState(this.desiredState);
            this.desiredTime = -1L;
        }
    }

    @Override
    public PlayState getPlayState() {
        return this.playState;
    }

    @Override
    public boolean isReadyToPlay() {
        if (this.buffer == null) {
            return false;
        }
        return this.countDown <= 0 && !this.buffer.isEmpty();
    }

    @Override
    public boolean isStopped() {
        return this.playState == PlayState.STOP;
    }

    @Override
    public void setPlayState(PlayState state, long when) {
        if (state == PlayState.STOP) {
            this.desiredState = state;
            this.desiredTime = when;
        } else {
            this.setPlayState(state);
        }
    }

    protected void setPlayState(PlayState state) {
        if (this.playState == PlayState.STOP != (state == PlayState.STOP)) {
            this.isPlayModeModified = true;
        }
        this.playState = state;
    }

    @Override
    public long getEndTime() {
        if (this.isEndOfFile) {
            long fileDuration = this.nbReadFrames;
            if (this.resampler != null) {
                fileDuration = (long)((double)fileDuration * this.resampler.getRatio() + 1.0);
            }
            return this.startTime + fileDuration;
        }
        return -1L;
    }

    @Override
    public float[][] getNextBlock() {
        try {
            float[] data = this.buffer.take();
            int nbFrames = data.length / this.nbChannels;
            if (this.output == null || this.output.length != this.nbChannels || this.output[0].length != nbFrames) {
                this.output = new float[this.nbChannels][nbFrames];
            }
            int chan = 0;
            while (chan < this.nbChannels) {
                float[] out = this.output[chan];
                int src = chan;
                int dst = 0;
                while (dst < out.length) {
                    out[dst] = data[src];
                    src += this.nbChannels;
                    ++dst;
                }
                ++chan;
            }
            return this.output;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            super.log(GraphErrorType.ServerError, Severity.Error, "Interrupted: {0}", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                AudioInputStream source = null;
                FileReader fileReader = this;
                synchronized (fileReader) {
                    while (this.audioStream == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    source = this.audioStream;
                }
                int nbCycles = this.queueSize + 2;
                int nbFrames = AudioConfig.blockSize();
                int nbSamples = nbFrames * this.nbChannels;
                int nbBytes = nbSamples * 2;
                if (this.sampleBuffers == null || this.sampleBuffers.length != nbCycles || this.sampleBuffers[0].length != nbSamples) {
                    this.sampleBuffers = new float[nbCycles][nbSamples];
                    this.cycleIndex = 0;
                }
                if (this.dataBuffers == null || this.dataBuffers.length != nbCycles || this.dataBuffers[0].length != nbBytes) {
                    this.dataBuffers = new byte[nbCycles][nbBytes];
                    this.cycleIndex = 0;
                }
                byte[] data = this.dataBuffers[this.cycleIndex];
                float[] samples = this.sampleBuffers[this.cycleIndex];
                if (!this.isEndOfFile) {
                    try {
                        AudioInputStream audioInputStream = source;
                        synchronized (audioInputStream) {
                            int offset = 0;
                            int read = source.read(data, offset, data.length - offset);
                            while (offset < data.length) {
                                if (read < 0) {
                                    this.isEndOfFile = true;
                                    Arrays.fill(data, offset, data.length, (byte)0);
                                    break;
                                }
                                read = source.read(data, offset += read, data.length - offset);
                            }
                            read = offset;
                            if (read > 0) {
                                this.nbReadFrames += (long)(read * nbFrames / nbBytes);
                            }
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    int src = 0;
                    int dst = 0;
                    while (dst < nbSamples) {
                        byte a = data[src++];
                        byte b = data[src++];
                        int value = a & 0xFF | b << 8;
                        samples[dst] = (float)value / 32767.0f;
                        ++dst;
                    }
                } else {
                    Arrays.fill(samples, 0.0f);
                }
                try {
                    this.buffer.put(samples);
                }
                catch (InterruptedException ex) {
                    return;
                }
                this.cycleIndex = (this.cycleIndex + 1) % nbCycles;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isSource() {
        return true;
    }
}

