/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.line;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletPriority;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateBouncelet;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InFile;
import org.corebounce.utils.Log;
import org.corebounce.utils.LowThreadFactory;
import org.corebounce.utils.Severity;

public class FileWriter
extends Bouncelet
implements PlayStateBouncelet,
Runnable {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InFile inFile = new InFile("file", "Output file/URL");
    public InDouble inBuffer = new InDouble("buffer", "Buffering length [s]", 0.5, 0.01, 10.0);
    private Thread writer;
    private int queueSize;
    private BlockingQueue<float[]> buffer;
    private static final float[] EOF = new float[0];
    private float[][] cycleBuffers;
    private int cycleIndex;
    private static final int BUFFER_SIZE = 65536;
    private ShortBuffer fileBuffer;
    private List<ShortBuffer> fileBuffers;
    private int fileBufferSize;
    private int fileBufferIndex;
    private long frameCount;
    private int nbChannels;
    private long lastLogTime = 0L;
    private PlayState playState = PlayState.STOP;
    private PlayState desiredState = PlayState.STOP;
    private long desiredTime = -1L;
    private boolean isPlayModeModified = false;

    public FileWriter() {
        super("audio.line.file.file-writer", "Write audio to a file or URL", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inFile.setSkillType(SkillType.SIMPLIFIED);
        this.inBuffer.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.record();
        this.handleStateChange();
    }

    private void setup() {
        if (this.isPlayModeModified) {
            this.closeFile(true);
            this.isPlayModeModified = false;
            if (!this.playState.equals((Object)PlayState.STOP)) {
                this.openFile();
            }
            this.createCyclicPool();
        }
    }

    @Override
    public void dispose() {
        this.closeFile(false);
        super.dispose();
    }

    private void createCyclicPool() {
        WaveData wave = (WaveData)this.inAudio.peek();
        double blockDuration = (double)AudioConfig.blockSize() / (double)AudioConfig.getSampleRate();
        this.queueSize = (int)((Double)this.inBuffer.read() / blockDuration) + 1;
        this.cycleBuffers = new float[this.queueSize + 2][wave.nbFrames * wave.nbChannels];
        this.cycleIndex = 0;
    }

    private static String fileName(String url) {
        int pos = url.lastIndexOf(47);
        String result = url.substring(pos + 1);
        try {
            return URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return result;
        }
    }

    private void closeFile(boolean saveIt) {
        if (this.writer != null) {
            if (this.buffer != null) {
                try {
                    this.buffer.put(EOF);
                }
                catch (InterruptedException ex) {
                    throw new InternalError("Interrupted while pushing EOF");
                }
            } else {
                this.writer.interrupt();
            }
            try {
                this.writer.join(5000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.writer = null;
            if (saveIt) {
                this.saveFile();
            } else {
                this.releaseFile();
            }
        }
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFile() {
        WaveData wave = (WaveData)this.inAudio.peek();
        URL url = (URL)this.inFile.read();
        if (url != null) {
            this.fileBufferSize = 65536;
            int waveSize = wave.nbFrames * 2 * wave.nbChannels;
            if (this.fileBufferSize % waveSize != 0) {
                this.fileBufferSize = this.fileBufferSize + waveSize - this.fileBufferSize % waveSize;
            }
            assert (this.fileBufferSize > 0 && this.fileBufferSize % waveSize == 0);
            this.fileBufferIndex = 0;
            this.fileBuffers = new ArrayList<ShortBuffer>();
            this.fileBuffer = null;
            this.frameCount = 0L;
            this.createCyclicPool();
            Log.debug("Creating queue of {0} buffers", this.queueSize);
            this.buffer = new ArrayBlockingQueue<float[]>(this.queueSize);
            this.writer = LowThreadFactory.getInstance().createThread(this, "FileWriter Thread", true);
            FileWriter fileWriter = this;
            synchronized (fileWriter) {
                this.notify();
            }
        }
    }

    private void record() {
        WaveData wave = (WaveData)this.inAudio.read();
        float[] output = this.cycleBuffers[this.cycleIndex];
        this.cycleIndex = (this.cycleIndex + 1) % this.cycleBuffers.length;
        int chan = 0;
        while (chan < wave.nbChannels) {
            float[] input = wave.data[chan];
            int i = 0;
            int j = chan;
            while (i < input.length) {
                output[j] = input[i];
                ++i;
                j += wave.nbChannels;
            }
            ++chan;
        }
        if (this.playState == PlayState.PLAY && this.buffer != null) {
            this.frameCount += (long)wave.nbFrames;
            this.nbChannels = wave.nbChannels;
            try {
                this.buffer.put(output);
            }
            catch (InterruptedException ex) {
                throw new InternalError("Interrupted while pushing audio buffer");
            }
            if (System.currentTimeMillis() > this.lastLogTime + 10000L) {
                double duration = (double)this.frameCount / (double)AudioConfig.getSampleRate();
                int seconds = (int)duration;
                int minutes = seconds / 60;
                System.out.println("FileWriter: processed time: " + minutes + ":" + (seconds %= 60) / 10 + seconds % 10);
                this.lastLogTime = System.currentTimeMillis() + 10000L;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void saveFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void releaseFile() {
        this.fileBuffers = null;
        this.fileBuffer = null;
    }

    private AudioFileFormat.Type getAudioFileType(URL url) {
        String path = url.getPath();
        AudioFileFormat.Type[] fileTypes = AudioSystem.getAudioFileTypes();
        AudioFileFormat.Type result = null;
        AudioFileFormat.Type[] typeArray = fileTypes;
        int n = fileTypes.length;
        int n2 = 0;
        while (n2 < n) {
            AudioFileFormat.Type fileType = typeArray[n2];
            if (path.endsWith(fileType.getExtension())) {
                result = fileType;
                break;
            }
            ++n2;
        }
        if (result == null) {
            int lastDot = path.lastIndexOf(46);
            if (lastDot >= 0) {
                String extension = path.substring(lastDot);
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "File format \"{0}\" not supported. Saving in AIFF instead.", extension);
            }
            result = AudioFileFormat.Type.AIFF;
        }
        return result;
    }

    private void handleStateChange() {
        if (this.desiredTime >= 0L && this.getTime() >= this.desiredTime) {
            this.setPlayState(this.desiredState);
            this.desiredTime = -1L;
        }
    }

    @Override
    public PlayState getPlayState() {
        return this.playState;
    }

    @Override
    public boolean isReadyToPlay() {
        return this.buffer != null;
    }

    @Override
    public boolean isStopped() {
        return this.playState == PlayState.STOP && this.writer == null;
    }

    @Override
    public void setPlayState(PlayState state, long when) {
        if (state == PlayState.STOP) {
            this.desiredState = state;
            this.desiredTime = when;
        } else {
            this.setPlayState(state);
        }
    }

    private void setPlayState(PlayState state) {
        if (this.playState == PlayState.STOP != (state == PlayState.STOP)) {
            this.isPlayModeModified = true;
        }
        this.playState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        short[] samples = null;
        while (!Thread.interrupted()) {
            float[] data;
            FileWriter fileWriter = this;
            synchronized (fileWriter) {
                while (this.buffer == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                }
            }
            try {
                data = this.buffer.take();
            }
            catch (InterruptedException ex) {
                throw new InternalError("Interrupted while taking buffer");
            }
            if (data == EOF) {
                return;
            }
            if (samples == null || samples.length != data.length) {
                samples = new short[data.length];
            }
            int i = 0;
            while (i < data.length) {
                samples[i] = data[i] > 1.0f ? Short.MAX_VALUE : (data[i] < -1.0f ? Short.MIN_VALUE : (data[i] >= 0.0f ? (short)(data[i] * 32767.0f + 0.5f) : (short)(data[i] * 32767.0f - 0.5f)));
                ++i;
            }
            if (this.fileBuffer == null || this.fileBufferIndex >= this.fileBufferSize) {
                ByteBuffer bbuffer = ByteBuffer.allocateDirect(131072);
                this.fileBuffer = bbuffer.asShortBuffer();
                this.fileBufferIndex = 0;
                this.fileBuffers.add(this.fileBuffer);
            }
            this.fileBuffer.put(samples);
            this.fileBufferIndex += samples.length;
        }
    }

    @Override
    public BounceletPriority getPriority() {
        return BounceletPriority.SINK;
    }

    @Override
    public boolean isSink() {
        return true;
    }

    private class MemoryInputStream
    extends InputStream {
        private int listIndex = -1;
        private int bufferIndex = 0;
        private ShortBuffer curBuffer = null;
        private int curLimit = 0;
        private boolean isPending = false;
        private int pending;

        private MemoryInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (this.isPending) {
                this.isPending = false;
                return this.pending;
            }
            if (this.curBuffer == null) {
                ++this.listIndex;
                if (this.listIndex < FileWriter.this.fileBuffers.size()) {
                    this.curBuffer = (ShortBuffer)FileWriter.this.fileBuffers.get(this.listIndex);
                    this.curLimit = this.curBuffer.limit();
                    this.bufferIndex = 0;
                } else {
                    --this.listIndex;
                    return -1;
                }
            }
            short value = this.curBuffer.get(this.bufferIndex++);
            if (this.bufferIndex >= this.curLimit) {
                this.curBuffer = null;
            }
            int result = value >>> 8;
            this.pending = value & 0xFF;
            this.isPending = true;
            return result;
        }
    }
}

