/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.line;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InInt;

public class Silence
extends Bouncelet {
    public InInt inChannels = new InInt("channels", "Number of channels", 1, 1, 16);
    public OutAudio outAudio = new OutAudio("out", "Silence");
    private int nbFrames;
    private int nbChannels;
    private WindowInfo noWindow;

    public Silence() {
        super("audio.line.silence", "Generate silence");
        super.setSkillType(SkillType.EXPERT);
        this.inChannels.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        int nbChannels;
        int nbFrames = AudioConfig.blockSize();
        assert (nbFrames != 0);
        if (this.nbFrames != nbFrames) {
            this.nbFrames = nbFrames;
            this.noWindow = WindowInfo.noWindow(nbFrames);
        }
        if (this.nbChannels != (nbChannels = ((Integer)this.inChannels.read()).intValue())) {
            this.nbChannels = nbChannels;
        }
        this.outAudio.prepare(nbChannels, nbFrames, this.noWindow);
        WaveData wave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < wave.nbChannels) {
            Arrays.fill(wave.data[chan], 0.0f);
            ++chan;
        }
    }

    @Override
    public boolean isSource() {
        return true;
    }
}

