/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.ports;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.utils.CacheMap;
import org.corebounce.utils.MultiKey;

public class InAudio
extends InputPort<WaveData> {
    private static CacheMap<MultiKey, WaveData> emptyWavesCache = new CacheMap();

    public InAudio(String name, String description) {
        super(WaveData.class, name, description, null, true);
        this.setSkillType(SkillType.SIMPLIFIED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WaveData getEmptyWave(int nbChannels, int blockSize, WindowInfo windowing) {
        MultiKey key = new MultiKey(nbChannels, blockSize, windowing);
        CacheMap<MultiKey, WaveData> cacheMap = emptyWavesCache;
        synchronized (cacheMap) {
            WaveData result = emptyWavesCache.get(key);
            if (result == null) {
                result = new WaveData(nbChannels, blockSize, windowing);
                emptyWavesCache.put(key, result);
            }
            return result;
        }
    }

    private static WaveData getDefaultWave() {
        int blockSize = AudioConfig.blockSize();
        assert (blockSize != 0);
        int channels = 2;
        WaveData result = InAudio.getEmptyWave(channels, blockSize, null);
        result.windowing.setWindowModified(false);
        return result;
    }

    @Override
    public void reset() {
        this.data = this.data != null ? InAudio.getEmptyWave(((WaveData)this.data).nbChannels, ((WaveData)this.data).nbFrames, ((WaveData)this.data).windowing) : InAudio.getDefaultWave();
    }
}

