/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.ports;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.utils.CacheMap;
import org.corebounce.utils.MultiKey;

public class InFrequencies
extends InputPort<FrequenciesData> {
    private static CacheMap<MultiKey, FrequenciesData> emptyFreqsCache = new CacheMap();

    public InFrequencies(String name, String description) {
        super(FrequenciesData.class, name, description);
        this.setSkillType(SkillType.SIMPLIFIED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FrequenciesData getEmptyFreqs(int nbChannels, int nbBins) {
        MultiKey key = new MultiKey(nbChannels, nbBins);
        CacheMap<MultiKey, FrequenciesData> cacheMap = emptyFreqsCache;
        synchronized (cacheMap) {
            FrequenciesData result = emptyFreqsCache.get(key);
            if (result == null) {
                result = new FrequenciesData(nbChannels, nbBins);
                emptyFreqsCache.put(key, result);
            }
            return result;
        }
    }

    private static FrequenciesData getDefaultFreqs() {
        int blockSize = AudioConfig.blockSize();
        assert (blockSize != 0);
        int channels = 2;
        return InFrequencies.getEmptyFreqs(channels, blockSize / 2 + 1);
    }

    @Override
    public void reset() {
        this.data = this.data != null ? InFrequencies.getEmptyFreqs(((FrequenciesData)this.data).nbChannels, ((FrequenciesData)this.data).nbBins) : InFrequencies.getDefaultFreqs();
    }
}

