/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import java.util.Random;
import org.corebounce.decklight.bouncelets.audio.synth.wave.WaveGeneratorBouncelet;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Pepper
extends WaveGeneratorBouncelet {
    public InDouble inFrequency = new InDouble("frequency", "Tone frequency [Hz]", 440.0, 16.0, 22050.0);
    private final Random rnd = new Random();
    private float value = 0.707f;
    private double angle = 0.0;

    public Pepper() {
        super("audio.synth.wave.pepper", "Generate randomly spaced pulses", "Pepper noise");
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void generate(float[] samples, float sampleRate) {
        double inc = (Double)this.inFrequency.read() / (double)sampleRate;
        int i = 0;
        while (i < samples.length) {
            this.angle += inc;
            float result = 0.0f;
            while (this.angle >= 1.0) {
                if (this.rnd.nextBoolean()) {
                    result = this.value = -this.value;
                }
                this.angle -= 1.0;
            }
            samples[i] = result;
            ++i;
        }
    }
}

