/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import java.util.Random;
import org.corebounce.decklight.bouncelets.audio.synth.wave.WaveGeneratorBouncelet;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class Thunder
extends WaveGeneratorBouncelet {
    public InDouble inFrequencyMin = new InDouble("frequency.min", "Tone frequency [Hz]", 160.0, 16.0, 1000.0);
    public InDouble inFrequencyMax = new InDouble("frequency.max", "Tone frequency [Hz]", 2500.0, 32.0, 10000.0);
    public InInt inMax = new InInt("max", "Lowest frequency divider", 4, 2, 16);
    private final Random rnd = new Random();
    private float value = 0.707f;
    private double inc = 1.0;
    private double angle = 1.0;
    private int counter = 0;

    public Thunder() {
        super("audio.synth.wave.thunder", "Generate random thunder (barcode-like noise)", "Thunder noise");
        this.inFrequencyMin.setScaleType(ScaleType.LOG2);
        this.inFrequencyMax.setScaleType(ScaleType.LOG2);
        this.inFrequencyMin.setSkillType(SkillType.SIMPLIFIED);
        this.inFrequencyMax.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void generate(float[] samples, float sampleRate) {
        int i = 0;
        while (i < samples.length) {
            samples[i] = this.value;
            this.angle += this.inc;
            while (this.angle >= 1.0) {
                if (this.counter++ > (Integer)this.inMax.read() || this.rnd.nextBoolean()) {
                    this.value = -this.value;
                    this.counter = 0;
                    double min = (Double)this.inFrequencyMin.read();
                    double max = (Double)this.inFrequencyMax.read();
                    double freq = min + this.rnd.nextDouble() * (max - min);
                    this.inc = freq / (double)sampleRate;
                }
                this.angle -= 1.0;
            }
            ++i;
        }
    }
}

