/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bouncelets.music.AmCurve;
import org.corebounce.decklight.bouncelets.music.FmCurve;
import org.corebounce.decklight.bouncelets.music.MidiAction;
import org.corebounce.decklight.bouncelets.music.MidiEvent;
import org.corebounce.decklight.bouncelets.music.Note;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.ports.InAmCurve;
import org.corebounce.decklight.bouncelets.music.ports.InFmCurve;
import org.corebounce.decklight.bouncelets.music.ports.InMidi;
import org.corebounce.decklight.bouncelets.music.ports.InTone;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InInt;

public class Instrument
extends Bouncelet {
    public InMidi inMidi = new InMidi("midi", "Midi events");
    public InInt inChannel = new InInt("channel", "Midi channel to listen to", 0, 0, 15);
    public InTone inTone = new InTone("tone", "The tone to play");
    public InAmCurve inAmCurve = new InAmCurve("am", "The amplitude curve to apply");
    public InFmCurve inFmCurve = new InFmCurve("fm", "The frequency curve to apply");
    public InInt inPolyphony = new InInt("polyphony", "Maximum number of simultaneous notes", 4, 1, 32);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private int nbFrames;
    private WindowInfo noWindow;
    private Note[] notes;

    public Instrument() {
        super("music.instrument", "Tranform midi events into tones with enveloppe and frequency");
        this.inMidi.setSkillType(SkillType.SIMPLIFIED);
        this.inChannel.setSkillType(SkillType.SIMPLIFIED);
    }

    private Note findNote(int note, boolean onOnly) {
        int i = 0;
        while (i < this.notes.length) {
            if ((!onOnly || this.notes[i].isOn()) && this.notes[i].getKey() == note) {
                return this.notes[i];
            }
            ++i;
        }
        return null;
    }

    private Note findNewNote() {
        Note result = this.notes[0];
        int i = 1;
        while (i < this.notes.length) {
            if (this.notes[i].compareTo(result) > 0) {
                result = this.notes[i];
            }
            ++i;
        }
        return result;
    }

    @Override
    public void cycle() {
        this.update();
        this.prepare();
        this.generate();
    }

    private void update() {
        if (this.inPolyphony.isModified()) {
            int num = (Integer)this.inPolyphony.read();
            Note[] old = this.notes;
            this.notes = new Note[num];
            int i = 0;
            while (i < this.notes.length) {
                this.notes[i] = old != null && i < old.length ? old[i] : new Note();
                ++i;
            }
        }
        while (this.inMidi.isModified()) {
            Note note;
            int key;
            MidiEvent event = (MidiEvent)this.inMidi.read();
            if (event.getChannel() != ((Integer)this.inChannel.read()).intValue()) continue;
            MidiAction action = event.getAction();
            if (action.equals((Object)MidiAction.NOTE_ON)) {
                key = event.getData1();
                int velocity = event.getData2();
                Note note2 = this.findNote(key, false);
                if (note2 == null) {
                    note2 = this.findNewNote();
                }
                note2.noteOn(key, velocity, this.getTime());
                continue;
            }
            if (!action.equals((Object)MidiAction.NOTE_OFF) || (note = this.findNote(key = event.getData1(), true)) == null) continue;
            note.noteOff(this.getTime());
        }
    }

    private void prepare() {
        int nbFrames = AudioConfig.blockSize();
        assert (nbFrames != 0);
        if (this.nbFrames != nbFrames) {
            this.nbFrames = nbFrames;
            this.noWindow = WindowInfo.noWindow(nbFrames);
        }
        this.outAudio.prepare(1, nbFrames, this.noWindow);
    }

    private void generate() {
        Tone tone = (Tone)this.inTone.read();
        AmCurve amCurve = (AmCurve)this.inAmCurve.read();
        FmCurve fmCurve = (FmCurve)this.inFmCurve.read();
        WaveData wave = (WaveData)this.outAudio.get();
        float[] output = wave.data[0];
        Arrays.fill(output, 0.0f);
        double sampleDuration = 1.0 / (double)AudioConfig.getSampleRate();
        Note[] noteArray = this.notes;
        int n = this.notes.length;
        int n2 = 0;
        while (n2 < n) {
            Note note = noteArray[n2];
            note.mix(tone, amCurve, fmCurve, sampleDuration, output);
            ++n2;
        }
    }
}

