/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.music.AmCurve;
import org.corebounce.decklight.bouncelets.music.FmCurve;
import org.corebounce.decklight.bouncelets.music.Tone;

class Note
implements Comparable<Note> {
    private static final double HALF_TONE_INC = Math.pow(2.0, 0.08333333333333333);
    private static final double A_FREQUENCY = 440.0;
    private static final int MIDDLE_A = 69;
    private int key;
    private int velocity;
    private boolean on;
    private double onTime;
    private double offTime;
    private double frequency = 440.0;
    private double amplitude = 0.0;
    private double curveTime = 0.0;
    private double curveNoteOff = -1.0;
    private double toneTime = 0.0;
    private double toneNoteOff = -1.0;

    public void noteOn(int note, int velocity, double curTime) {
        this.key = note;
        this.velocity = velocity;
        this.on = true;
        this.onTime = curTime;
        this.offTime = -1.0;
        this.curveTime = 0.0;
        this.toneTime = 0.0;
        this.curveNoteOff = -1.0;
        this.toneNoteOff = -1.0;
        this.frequency = 440.0 * Math.pow(HALF_TONE_INC, this.key - 69);
        double dbLevel = (double)velocity - 100.0;
        this.amplitude = AudioMath.dbToLevel(dbLevel);
    }

    public void noteOff(double curTime) {
        this.curveNoteOff = this.curveTime;
        this.toneNoteOff = this.toneTime;
        this.on = false;
        this.offTime = curTime;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int note) {
        this.key = note;
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    @Override
    public int compareTo(Note other) {
        if (this.on) {
            if (!other.on) {
                return -1;
            }
            if (this.onTime > other.onTime) {
                return -1;
            }
            if (this.onTime < other.onTime) {
                return 1;
            }
            return 0;
        }
        if (other.on) {
            return 1;
        }
        if (this.offTime > other.offTime) {
            return -1;
        }
        if (this.offTime < other.offTime) {
            return 1;
        }
        return 0;
    }

    public void mix(Tone tone, AmCurve amCurve, FmCurve fmCurve, double sampleDuration, float[] output) {
        int i = 0;
        while (i < output.length) {
            double am = amCurve.getAmplitude(this.curveNoteOff, this.curveTime);
            double fm = fmCurve.getRatio(this.curveNoteOff, this.curveTime);
            double modulatedDuration = sampleDuration * this.frequency * fm / 440.0;
            double sample = tone.getSample(this.toneNoteOff, this.toneTime, this.toneTime + modulatedDuration);
            int n = i++;
            output[n] = output[n] + (float)(sample * this.amplitude * am);
            this.curveTime += sampleDuration;
            this.toneTime += modulatedDuration;
        }
    }
}

