/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.amplitude;

import org.corebounce.decklight.bouncelets.music.AmCurve;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.amplitude.AmCurveWrapper;
import org.corebounce.decklight.bouncelets.music.amplitude.AmEffect;
import org.corebounce.decklight.bouncelets.music.ports.InTone;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Tremolo
extends AmEffect {
    public InTone inModulator = new InTone("tone", "Modulation tone");
    public InDouble inFrequency = new InDouble("frequency", "Modulation frequency", 4.0, 0.01, 100.0);
    public InDouble inAmplitude = new InDouble("amplitude", "Modulation amplitude", 0.5, -2.0, 2.0);
    private double timeRatio;
    private double amplitude;

    public Tremolo() {
        super("music.amplitude.tremolo", "Modulate the amplitude curve using a tone");
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inModulator.setSkillType(SkillType.SIMPLIFIED);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
        this.inAmplitude.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    protected boolean isModified() {
        return this.inFrequency.isModified() || this.inAmplitude.isModified();
    }

    @Override
    protected boolean isCurveModified() {
        return super.isCurveModified() || this.inModulator.isModified();
    }

    @Override
    protected void updateParameters() {
        this.timeRatio = (Double)this.inFrequency.read() / 440.0;
        this.amplitude = (Double)this.inAmplitude.read();
    }

    @Override
    protected AmCurve createTranform(AmCurve source) {
        final Tone modulator = (Tone)this.inModulator.read();
        return new AmCurveWrapper(source){

            @Override
            public double getAmplitude(double offTime, double elapsed) {
                double scaledElapsed = elapsed * Tremolo.this.timeRatio;
                double scaledOffTime = offTime * Tremolo.this.timeRatio;
                double modulation = modulator.getSample(scaledOffTime, scaledElapsed, scaledElapsed);
                modulation = 1.0 - modulation * Tremolo.this.amplitude / 2.0;
                return this.source.getAmplitude(offTime, elapsed) * modulation;
            }
        };
    }
}

