/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Amplify
extends ToneEffect {
    public InDouble inLevel = new InDouble("level", "Amplitude", 1.0, -3.0, 3.0);
    public InDouble inOffset = new InDouble("offset", "DC offset", 0.0, -1.0, 1.0);
    private double level;
    private double offset;

    public Amplify() {
        super("music.effect.amplify", "Modify amplitude and DC");
        this.inLevel.setSkillType(SkillType.SIMPLIFIED);
        this.inOffset.setSkillType(SkillType.ADVANCED);
    }

    @Override
    protected boolean isModified() {
        return this.inLevel.isModified() || this.inOffset.isModified();
    }

    @Override
    protected void updateParameters() {
        this.level = (Double)this.inLevel.read();
        this.offset = (Double)this.inOffset.read();
    }

    @Override
    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            @Override
            public double getSample(double offTime, double begTime, double endTime) {
                return this.source.getSample(offTime, begTime, endTime) * Amplify.this.level + Amplify.this.offset;
            }
        };
    }
}

