/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import java.util.Arrays;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.utils.Log;

public class Cache
extends ToneEffect {
    private static final float UNDEFINED = -10000.0f;
    public InInt inSampling = new InInt("sampling", "Sampling points", 512, 100, 10000);
    public InDouble inMaxSize = new InDouble("size.max", "Maximum size [s]", 5.0, 0.0, 100.0);
    private double sampling;
    private double increment;
    private float[] buffer;
    private double maxSize;

    public Cache() {
        super("music.effect.cache", "Cache intermediate tones for faster synthesis");
    }

    @Override
    protected boolean isModified() {
        return this.inSampling.isModified();
    }

    @Override
    protected void updateParameters() {
        this.sampling = ((Integer)this.inSampling.read()).intValue();
        this.increment = 1.0 / (this.sampling * 440.0);
        this.resetCache();
    }

    @Override
    protected void updateTone(Tone source) {
        this.resetCache();
    }

    private void resetCache() {
        if (this.buffer != null) {
            Arrays.fill(this.buffer, -10000.0f);
        }
        Log.debug("{0} reseting cache", this);
    }

    @Override
    public void cycle() {
        if (this.inMaxSize.isModified()) {
            this.maxSize = (Double)this.inMaxSize.read();
        }
        super.cycle();
    }

    @Override
    protected Tone createTranform(Tone source) {
        this.resetCache();
        return new ToneWrapper(this, source){

            @Override
            public double getSample(double offTime, double begTime, double endTime) {
                double position;
                int index0;
                int index1;
                double period = this.source.getPeriod();
                double maxTime = period;
                if (maxTime > Cache.this.maxSize) {
                    maxTime = Cache.this.maxSize;
                }
                this.ensureSize((int)(maxTime * Cache.this.sampling * 440.0) + 1);
                double time = (begTime + endTime) / 2.0;
                if (time >= period) {
                    time %= period;
                }
                if ((index1 = (index0 = (int)(position = time * 440.0 * Cache.this.sampling)) + 1) < Cache.this.buffer.length) {
                    float weight1 = (float)(position - (double)index0);
                    float weight0 = 1.0f - weight1;
                    return this.valueAt(offTime, index0) * (double)weight0 + this.valueAt(offTime, index1) * (double)weight1;
                }
                return this.source.getSample(offTime, begTime, endTime);
            }

            private double valueAt(double offTime, int index) {
                if (Cache.this.buffer[index] != -10000.0f) {
                    return Cache.this.buffer[index];
                }
                double begTime = (double)index * Cache.this.increment;
                double result = this.source.getSample(offTime, begTime, begTime + Cache.this.increment);
                ((Cache)Cache.this).buffer[index] = (float)result;
                return result;
            }

            private void ensureSize(int size) {
                if (Cache.this.buffer == null || Cache.this.buffer.length < size) {
                    float[] result = new float[size];
                    if (Cache.this.buffer != null) {
                        System.arraycopy(Cache.this.buffer, 0, result, 0, Cache.this.buffer.length);
                        Arrays.fill(result, Cache.this.buffer.length, result.length, -10000.0f);
                    } else {
                        Arrays.fill(result, -10000.0f);
                    }
                    Log.info("Creating buffer of size {0}", result.length);
                    Cache.this.buffer = result;
                }
            }
        };
    }
}

