/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Chord
extends ToneEffect {
    public InDouble inLevel0 = new InDouble("level0", "Main tone level", 0.0, -100.0, 20.0);
    public InDouble inRatio1 = new InDouble("ratio1", "First ratio", 1.25, 0.25, 4.0);
    public InDouble inLevel1 = new InDouble("level1", "First level [dB]", -5.0, -100.0, 20.0);
    public InDouble inRatio2 = new InDouble("ratio2", "Second ratio", 1.5, 0.25, 4.0);
    public InDouble inLevel2 = new InDouble("level2", "First level [dB]", -10.0, -100.0, 20.0);
    public InDouble inRatio3 = new InDouble("ratio3", "Third ratio", 2.0, 0.25, 4.0);
    public InDouble inLevel3 = new InDouble("level3", "First level [dB]", -100.0, -100.0, 20.0);
    public InDouble inRatio4 = new InDouble("ratio4", "Fourth ratio", 0.8, 0.25, 4.0);
    public InDouble inLevel4 = new InDouble("level4", "First level [dB]", -100.0, -100.0, 20.0);
    public InDouble inRatio5 = new InDouble("ratio5", "Fifth ratio", 1.3333333333333333, 0.25, 4.0);
    public InDouble inLevel5 = new InDouble("level5", "First level [dB]", -100.0, -100.0, 20.0);
    public InDouble inRatio6 = new InDouble("ratio6", "Sixth ratio", 0.75, 0.25, 4.0);
    public InDouble inLevel6 = new InDouble("level6", "First level [dB]", -100.0, -100.0, 20.0);
    public InDouble inRatio7 = new InDouble("ratio7", "Seventh ratio", 1.7777777777777777, 0.25, 4.0);
    public InDouble inLevel7 = new InDouble("level7", "First level [dB]", -100.0, -100.0, 20.0);
    private InDouble[] inRatios = new InDouble[]{this.inRatio1, this.inRatio2, this.inRatio3, this.inRatio4, this.inRatio5, this.inRatio6, this.inRatio7};
    private InDouble[] inLevels = new InDouble[]{this.inLevel1, this.inLevel2, this.inLevel3, this.inLevel4, this.inLevel5, this.inLevel6, this.inLevel7};
    private double[] ratios = new double[this.inRatios.length];
    private double[] levels = new double[this.inLevels.length];
    private double mainLevel;
    private double correction;

    public Chord() {
        super("music.effect.chord", "Mix with shifted versions");
        InDouble[] inDoubleArray = this.inRatios;
        int n = this.inRatios.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inRatio = inDoubleArray[n2];
            inRatio.setScaleType(ScaleType.LOG2);
            ++n2;
        }
        int i = 0;
        while (i < 3) {
            this.inRatios[i].setSkillType(SkillType.SIMPLIFIED);
            this.inLevels[i].setSkillType(SkillType.SIMPLIFIED);
            ++i;
        }
    }

    @Override
    protected boolean isModified() {
        if (this.inLevel0.isModified()) {
            return true;
        }
        InDouble[] inDoubleArray = this.inRatios;
        int n = this.inRatios.length;
        int n2 = 0;
        while (n2 < n) {
            InDouble inRatio = inDoubleArray[n2];
            if (inRatio.isModified()) {
                return true;
            }
            ++n2;
        }
        inDoubleArray = this.inLevels;
        n = this.inLevels.length;
        n2 = 0;
        while (n2 < n) {
            InDouble inLevel = inDoubleArray[n2];
            if (inLevel.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void updateParameters() {
        double sum = 0.0;
        this.mainLevel = AudioMath.dbToLevel0((Double)this.inLevel0.read());
        sum += this.mainLevel;
        int i = 0;
        while (i < this.inRatios.length) {
            this.ratios[i] = (Double)this.inRatios[i].read();
            this.levels[i] = AudioMath.dbToLevel0((Double)this.inLevels[i].read());
            sum += this.levels[i];
            ++i;
        }
        this.correction = sum > 1.0 ? 1.0 / sum : 1.0;
    }

    @Override
    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            @Override
            public double getSample(double offTime, double begTime, double endTime) {
                double sum = this.source.getSample(offTime, begTime, endTime) * Chord.this.mainLevel;
                int i = 0;
                while (i < Chord.this.ratios.length) {
                    if (Chord.this.levels[i] > 0.0) {
                        double ratio = Chord.this.ratios[i];
                        sum += this.source.getSample(offTime * ratio, begTime * ratio, endTime * ratio) * Chord.this.levels[i];
                    }
                    ++i;
                }
                return sum * Chord.this.correction;
            }

            @Override
            public double getPeriod() {
                double inv = 0.0;
                int i = 0;
                while (i < Chord.this.ratios.length) {
                    if (Chord.this.levels[i] != 0.0) {
                        inv = AudioMath.gcd(inv, Chord.this.ratios[i]);
                    }
                    ++i;
                }
                inv = Math.round(1.0 / inv);
                return this.source.getPeriod() * inv;
            }
        };
    }
}

