/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.ports.InTone;
import org.corebounce.decklight.bouncelets.music.ports.OutTone;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.utils.Log;

public abstract class DualToneEffect
extends Bouncelet {
    public InTone inTone1 = new InTone("in1", "First tone");
    public InTone inTone2 = new InTone("in2", "Second tone");
    public OutTone outTone = new OutTone("out", "Output tone");
    private Tone result;
    private double lastChangeTime = 0.0;

    public DualToneEffect(String name, String description) {
        super(name, description);
        this.inTone1.setSkillType(SkillType.SIMPLIFIED);
        this.inTone2.setSkillType(SkillType.SIMPLIFIED);
        this.outTone.setSkillType(SkillType.SIMPLIFIED);
    }

    protected abstract boolean isModified();

    protected boolean isToneModified() {
        return this.inTone1.isModified() || this.inTone2.isModified();
    }

    protected double getLastChangeTime() {
        return this.lastChangeTime;
    }

    protected abstract void updateParameters();

    protected abstract Tone createTranform(Tone var1, Tone var2);

    @Override
    public void cycle() {
        if (this.isModified()) {
            this.updateParameters();
            this.lastChangeTime = super.getTime();
            Log.debug("Parameters modified in {0}", this);
        }
        if (this.isToneModified()) {
            Tone source1 = (Tone)this.inTone1.read();
            Tone source2 = (Tone)this.inTone2.read();
            this.result = this.createTranform(source1, source2);
            this.outTone.write(this.result);
            this.lastChangeTime = super.getTime();
            Log.debug("Source tone modified in {0}", this);
        } else {
            this.outTone.setModified(false);
        }
    }
}

